#include "vector.h"
#include <stdio.h>
#include <math.h>


double norm1 (double* a, int n)
{
  int i;
  double sum = 0;

  for (i = 0; i < n; i++) {
    sum += fabs(a[i]);
  }
  return sum;
}

void normalize (double *a, int n)
{
  int i;
  double sum = norm1(a, n);
  
  if (sum > 0) for (i = 0; i < n; i++) a[i] /= sum;
}

void point_sub(double* a, double* b, double* c,  int size)
{
  int i;

  for (i = 0; i < size; i++) {
    c[i] = a[i] - b[i];
  }
}

void point_sum(double* a, double* b, double* c, int size)
{
  int i;

  for (i = 0; i < size; i++) {
    c[i] = a[i] + b[i];
  }
}

double inner_product (double *a, int *b, int n)
{
  int i;
  double inner = 0;

  for (i = 0; i < n; i++) {
    inner += a[i] * b[i];
  }
  return inner;
}

void vector_matrix_product(double* x, Digraph L, int transpose, double* ans)
{
  Vertex v;
  link list;

  for (v = 0; v < L->V; v++) ans[v] = 0.0;

  if (transpose == 0) {
    for (v = 0; v < L->V; v++) {
      list = L->adj[v];
      while (list != NULL) {
        ans[list->w] += x[v];
        list = list->next;
      }
    }
  }
  else if (transpose == 1) {
    for (v = 0; v < L->V; v++) {
      list = L->adj[v];
      while (list != NULL) {
        ans[v] += x[list->w];
        list = list->next;
      }
    }
  }
  else {
    printf("FATAL ERROR!\n");
  }
}

