/* http:.../~pf/algoritmos_para_grafos/aulas/digraphdatastructs.html */

#ifndef _digraph_h
#define _digraph_h

/* Vértices são representados por objetos do tipo Vertex.  
   Os vértices de um digrafo são 0,1,..,V-1. */

#define Vertex int

/* A estrutura digraph representa um digrafo. 
 * O campo adj é um ponteiro para a matriz de adjacência do digrafo. 
 * O campo V contém o número de vértices e o campo A contém o 
 * número de arcos do digrafo. 
 */

typedef struct digraph *Digraph;
typedef struct node *link;

struct node {
    Vertex w;
    link next;
};

struct digraph {
    int V; 
    int A; 
    link *adj;
    int *out; 
    int *dng;
    char **URL;
};



/* Um objeto do tipo Digraph contém o endereço de um digraph. */

/* Esta função devolve (o endereço de) um novo digrafo com 
 * vértices 0,..,V-1 e nenhum arco. 
 */

Digraph DIGRAPHinit (int V);


/* A funcao NEW recebe um vertice w e o end next de um node e devolve
 * um novo node x com x.w = w e x.next = next */

link NEW (Vertex w, link next);


/* A função abaixo aloca uma matriz com linhas 0..r-1 e colunas 0..c-1. 
 * Cada elemento da matriz recebe valor val. 
 */

double** MATRIXint (int r, int c, float val);

/* Esta função insere um arco v-w no digrafo G. 
 * Se v == w ou o digrafo já tem arco v-w, a função não faz nada.  
 * É claro que v e w não podem ser negativos e devem ser menores que G->V. 
 */

void DIGRAPHurl (Digraph G, Vertex v, char *url);
void DIGRAPHinsertA (Digraph G, Vertex v, Vertex w);

/* Esta função remove do digrafo G o arco que tem ponta inicial 
 * v e ponta final w.  Se não existe tal arco, a função nada faz.
 */

void DIGRAPHremoveA (Digraph G, Vertex v, Vertex w);

/* Para cada vértice v do digrafo G, esta função imprime,
 * em uma linha, todos os vértices adjacentes a v. 
 */

void DIGRAPHshow (Digraph G);

/* Recebe um digrafo G e libera a memoria alocada 
 * a ele (matriz de adjacencia e estrutura
 */

void DIGRAPHfree (Digraph G);
void free_list (link list);

#endif
