package tcc.haruki.services.impl;

import java.math.BigInteger;
import java.util.Random;

import tcc.haruki.domain.GaloisField;
import tcc.haruki.domain.XTRElem;
import tcc.haruki.domain.XTRTrincaElem;
import tcc.haruki.domain.xtr.XTRParameters;
import tcc.haruki.services.XTROperationService;

@SuppressWarnings("unused")
public class XTROperationServiceImpl implements XTROperationService {

	private XTRParameters parameters;
	private GaloisField gf;
	private Random random;
	
	public XTROperationServiceImpl(XTRParameters parameters) {
		this.parameters = parameters;
		this.gf = parameters.getGF();
		this.random = new Random();
	}
	
	@Override
	public XTRElem exponenciacaoSimples(XTRElem trg, BigInteger n) {
		XTRTrincaElem sn = Sn(trg, n);
		return sn.get(0);
	}

	@Override
	public XTRElem exponenciacaoDupla(XTRElem trg, XTRTrincaElem sktrg,
			BigInteger a, BigInteger b) {
		BigInteger inversoB = b.modInverse(this.parameters.getQ());
		BigInteger e = a.multiply(inversoB).mod(this.parameters.getQ());
		BigInteger confere = e.multiply(b).mod(this.parameters.getQ());
		XTRTrincaElem se = Sn(trg, e);
		XTRElem[] passo3 = alg247(trg, se);
		
		XTRElem trgek = sktrg.get(-1).mul(passo3[0])
				.add(sktrg.get(0).mul(passo3[1]))
				.add(sktrg.get(1).mul(passo3[2]));
		
		XTRTrincaElem sb = Sn(trgek, b);
		
		return sb.get(0);
	}
	
	public XTRTrincaElem Sn(XTRElem c, BigInteger n) {
		XTRElem fst = null;
		XTRElem snd = null;
		XTRElem trd = null;
		
		BigInteger dois = new BigInteger("2");

		XTRTrincaElem Sk_;
		
		if (n.compareTo(BigInteger.ZERO) < 0) {
			XTRTrincaElem aux = Sn(c, n.negate());
			fst = aux.get(0).expP();
			snd = aux.get(1).expP();
			trd = aux.get(2).expP();
		} else if (n.compareTo(BigInteger.ZERO) == 0) {
			fst = c.expP();
			snd = new XTRElem(gf, new BigInteger("-3"), new BigInteger("-3"));
			trd = c;
		} else if (n.compareTo(BigInteger.ONE) == 0) {
			fst = new XTRElem(gf, new BigInteger("-3"), new BigInteger("-3"));
			snd = c;
			trd = c.mul(c).sub(c.expP().scalarMul(dois));
		} else if (n.compareTo(dois) == 0) {
			XTRTrincaElem anterior = Sn(c, BigInteger.ONE);
			fst = anterior.get(0);
			snd = anterior.get(1);
			trd = cnmais2(c, anterior);
		}
		
		else {
			BigInteger m = n.mod(dois).equals(BigInteger.ZERO) ? n
					.subtract(BigInteger.ONE) : n;
			BigInteger k = BigInteger.ONE;
			BigInteger aux = m.subtract(BigInteger.ONE).divide(dois);

			XTRTrincaElem S2 = Sn(c, dois);
			Sk_ = new XTRTrincaElem(S2.get(0), S2.get(1), cnmais2(c, S2));

			int r = aux.bitLength() - 1;
			for (int j = r - 1; j >= 0; j--) {
				if ((aux.and(BigInteger.ONE.shiftLeft(j))).equals(BigInteger.ZERO)) {
					XTRTrincaElem Saux_ = new XTRTrincaElem(c2n(c, Sk_.get(-1)),
										      c2nmenos1(c, Sk_),
										      c2n(c, Sk_.get(0)));
					k = k.multiply(dois);
					Sk_ = Saux_;
				} else {
					XTRTrincaElem Saux_ = new XTRTrincaElem(c2n(c, Sk_.get(0)), 
							                  c2nmais1(c, Sk_),
							                  c2n(c, Sk_.get(1)));
					k = k.multiply(dois).add(BigInteger.ONE);
					Sk_ = Saux_;
				}
			}

			XTRTrincaElem Sm = Sk_;
			if (n.mod(dois).equals(BigInteger.ZERO)) {
				return new XTRTrincaElem(Sm.get(0), Sm.get(1), cnmais2(c, Sm));
			} else
				return Sm;
		}
		return new XTRTrincaElem(fst, snd, trd);
	}
	
	public BigInteger random1AtehQ() {
		BigInteger retval;
		do {
			retval = new BigInteger(this.parameters.getQ().bitLength(), random);
		} while (retval.compareTo(BigInteger.ZERO) < 0 || retval.compareTo(parameters.getQ().subtract(new BigInteger("2"))) > 0);
		
		return retval;
	}

	@Override
	public XTRElem generateTraceOrderQ(XTRParameters params) {
		XTRElem c;
		XTRElem cpM1;
		XTRElem cbla;
		
		GaloisField gf = new GaloisField(params.getP());
		
		do {
			do {
				do {
					c =	new XTRElem(gf, gf.randomElement(), gf.randomElement());
				} while (c.isGFElement());
				
				XTRTrincaElem spM1 = this.Sn(c, gf.getP().add(BigInteger.ONE));
				cpM1 = spM1.get(0);
			} while (cpM1.isGFElement());
			
			XTRTrincaElem sbla = this.Sn(c, gf.getP().multiply(gf.getP()) .subtract(gf.getP()) .add(BigInteger.ONE) .divide(params.getQ()));
			cbla = sbla.get(0);
		} while (cbla.equals(new XTRElem(gf, new BigInteger("-3"), new BigInteger("-3"))));
		
		return cbla;
	}
	
	
	/* ************************************************************************************************ */
	/*                                                                                                  */
	/*                   AUXILIARES                                                                     */
	/*                                                                                                  */
	/* ************************************************************************************************ */
	
	
	private XTRElem[] alg247(XTRElem trg, XTRTrincaElem setrg) {
		XTRElem[][] m0tr = mzero(gf, trg);
		XTRElem[] v = new XTRElem[3];
		for (int i = 0; i < 3; i++) {
		v[i] = m0tr[i][0].mul(setrg.get(-1))
				.add(m0tr[i][1].mul(setrg.get(0)))
				.add(m0tr[i][2].mul(setrg.get(1)));
		}
		
		return v;
	}
	
	private XTRElem[][] mzero(GaloisField gf, XTRElem c) {
		BigInteger dois = new BigInteger("2");
		BigInteger tres = new BigInteger("3");
		XTRElem noveGF = new XTRElem(gf, new BigInteger("-9"), new BigInteger("-9"));
		
		XTRElem[][] matriz = new XTRElem[3][3];
		
		XTRElem c2 = c.exp2();
		XTRElem c2p = c2.expP();
		XTRElem cpmais2 = c2.mul(c.expP());
		
		XTRElem a = c2p.mul(c2);
		XTRElem b = c.expP().mul(c).scalarMul(new BigInteger("18"));
		XTRElem ca = (c2p.mul(c.expP()).add(c2.mul(c))).scalarMul(new BigInteger("4"));
		XTRElem lol = new XTRElem(gf, new BigInteger("-27"), new BigInteger("-27"));
		
		XTRElem Daux = c2p.mul(c2)
				.add(c.expP().mul(c).scalarMul(new BigInteger("18")))
				.sub((c2p.mul(c.expP()).add(c2.mul(c))).scalarMul(new BigInteger("4")));
		
		if (! Daux.isGFElement()) {
			System.err.println("ALO ERRO");
		}
		
		BigInteger D = Daux.getGFvalue().subtract(new BigInteger("27"));
		
		BigInteger umSobreD = D.modInverse(this.gf.getP());
		
		XTRElem aux00 = c2.scalarMul(dois).sub(c.expP().scalarMul(new BigInteger("6")));
		
		matriz[0][0] = aux00.scalarMul(umSobreD);
		matriz[0][1] = c2p.scalarMul(dois).add(c.scalarMul(tres)).sub(cpmais2).scalarMul(umSobreD);
		matriz[0][2] = c.mul(c.expP()).sub(noveGF).scalarMul(umSobreD);
		
		matriz[1][0] = matriz[0][1];
		XTRElem aux = c2.sub(c.expP().scalarMul(dois));
		matriz[1][1] = aux.expP().mul(aux).sub(noveGF).scalarMul(umSobreD);
		matriz[1][2] = (c2.expP().scalarMul(dois).add(c.scalarMul(tres)).sub(cpmais2)).expP().scalarMul(umSobreD);
		
		matriz[2][0] = matriz[0][2];
		matriz[2][1] = matriz[1][2];
		matriz[2][2] = aux00.expP().scalarMul(umSobreD);
		
		return matriz;
	}
	
	/**
	 * Corollary 2.35.i
	 * 
	 * @param c
	 * @param Sn
	 * @return
	 */
	private XTRElem c2n(XTRElem c, XTRElem cn) {
		XTRElem bla = cn.exp2().sub(cn.expP().scalarMul(new BigInteger("2")));
		return bla;
	}

	private XTRElem c2n(XTRElem c, XTRTrincaElem Sn) {
		return c2n(c, Sn.get(0));
	}

	/**
	 * Corollary 2.35.ii
	 * 
	 * @param c
	 * 			  c
	 * @param cnm1
	 *            c<sub>n-1</sub>
	 * @param cn
	 *            c<sub>n</sub>
	 * @param cnM1
	 *            c<sub>n+1</sub>
	 * @return
	 */
	private XTRElem cnmais2(XTRElem c, XTRElem cnm1, XTRElem cn,
			XTRElem cnM1) {
		return c.mul(cnM1).sub(c.expP().mul(cn)).add(cnm1);
	}

	private XTRElem cnmais2(XTRElem c, XTRTrincaElem Sn) {
		return cnmais2(c, Sn.get(-1), Sn.get(0), Sn.get(1));
	}

	/**
	 * Corollary 2.35.iii
	 * 
	 * @param c
	 * 			  c
	 * @param cnm1
	 *            c<sub>n-1</sub>
	 * @param cn
	 *            c<sub>n</sub>
	 * @param cnM1
	 *            c<sub>n+1</sub>
	 * @return
	 */
	private XTRElem c2nmenos1(XTRElem c, XTRElem cnm1, XTRElem cn,
			XTRElem cnM1) {
		return cnm1.mul(cn).sub(c.expP().mul(cn.expP())).add(cnM1.expP());
	}

	private XTRElem c2nmenos1(XTRElem c, XTRTrincaElem Sn) {
		return c2nmenos1(c, Sn.get(-1), Sn.get(0), Sn.get(1));
	}

	/**
	 * Corollary 2.35.iv
	 * 
	 * @param c 
	 * 		c
	 * @param cnm1
	 *            c<sub>n-1</sub>
	 * @param cn
	 *            c<sub>n</sub>
	 * @param cnM1
	 *            c<sub>n+1</sub>
	 * @return
	 */
	private XTRElem c2nmais1(XTRElem c, XTRTrincaElem Sn) {
		return Sn.get(1).mul(Sn.get(0)).sub(c.mul(Sn.get(0).expP()))
				.add(Sn.get(-1).expP());
	}

}
