package tcc.haruki.services;

import java.math.BigInteger;

import tcc.haruki.domain.XTRElem;
import tcc.haruki.domain.XTRTrincaElem;
import tcc.haruki.domain.xtr.XTRParameters;


public interface XTROperationService {
	/**
	 * Exponencia um certo elemento de GF(p<sup>2</sup>) a potência n.
	 * @param trg = Tr(g) = O elemento a ser exponenciado
	 * @param n O expoente
	 * @return Tr(g<sup>n</sup>)
	 */
	public XTRElem exponenciacaoSimples(XTRElem trg, BigInteger n);
	
	/**
	 * Recebe um elemento de GF(p<sup>2</sup>) e um elemento S<sub>k</sub> = 
	 * (Tr(g<sup>k-1</sup>), Tr(g<sup>k</sup>), Tr(g<sup>k+1</sup>)), inteiros a e b e
	 * calcula Tr(g<sup>a</sup> * g<sup>bk</sup>)
	 * 
	 * @param trg = Tr(g)
	 * @param sktrg = S<sub>k</sub>(Tr(g)) = (Tr(g<sup>k-1</sup>), Tr(g<sup>k</sup>), Tr(g<sup>k+1</sup>))
	 * @param a
	 * @param b
	 * @return Tr(g<sup>a</sup> * g<sup>bk</sup>)
	 */
	public XTRElem exponenciacaoDupla(XTRElem trg, XTRTrincaElem sktrg, BigInteger a, BigInteger b);
	
	
	/**
	 * Calcula uma trinca (c<sup>n-1</sup>, c<sup>n</sup>, c<sup>n+1</sup>)
	 * 
	 * @param c
	 * @param n
	 * @return S<sub>n</sub>(c) = (c<sup>n-1</sup>, c<sup>n</sup>, c<sup>n+1</sup>)
	 */
	public XTRTrincaElem Sn(XTRElem c, BigInteger n);
	
	/**
	 * Gera um aleatório k, onde 0 < k < q - 2
	 * @return k
	 */
	public BigInteger random1AtehQ();
	
	/**
	 * Gera um Tr(g) pertencente a GF(p<sup>2</sup>) com ordem <code>q</code>
	 * @param gf
	 * @param q
	 * @return Tr(g) de ordem q
	 */
	public XTRElem generateTraceOrderQ(XTRParameters params);
	
}
