package tcc.haruki.domain.xtr;

import java.math.BigInteger;
import java.util.Random;

import tcc.haruki.domain.GaloisField;

public class XTRParameters {

	private BigInteger p;
	private BigInteger q;
	private GaloisField gf;
	
	private static final int P = 170;
	private static final int Q = 160;
	
	private XTRParameters(BigInteger p, BigInteger q) {
		this.p = p;
		this.q = q;
		this.gf = new GaloisField(this.p);
	}
	
	public static XTRParameters makeParametersWith(BigInteger p, BigInteger q) throws Exception {
		XTRParameters params = new XTRParameters(p, q);
		if (params.getP() == null || params.getQ() == null) {
			throw new Exception("Parâmetro XTR p ou q nulo");
		}
		return params;
	}
	
	public BigInteger getP() {
		return this.p;
	}
	
	public BigInteger getQ() {
		return this.q;
	}
	
	public GaloisField getGF() {
		return this.gf;
	}
	
	public static XTRParameters generateParameters() {
		return generateParameters(P, Q);
	}
	
	public static XTRParameters generateParameters(int sizeOfP, int sizeOfQ) {
		Random random = new Random();
		
		BigInteger r, k, q, p;
		BigInteger tres = new BigInteger("3");
		BigInteger dois = new BigInteger("2");
		do {
			r = new BigInteger(sizeOfQ/2, random);
			q = r.multiply(r).subtract(r).add(BigInteger.ONE);
		} while (! q.isProbablePrime(100));
		
		do {
			k = new BigInteger(sizeOfP-sizeOfQ, random);
			p = r.add(k.multiply(q));
		} while (! (p.isProbablePrime(100)  && p.mod(tres).equals(dois)));
		
		XTRParameters param = new XTRParameters(p, q);
		
		return param;
	}
}
