package tcc.haruki.domain;

import java.math.BigInteger;
import java.util.Arrays;


public class XTRTrincaElem{

	private XTRElem v[];
	
	public XTRTrincaElem(XTRElem a, XTRElem b, XTRElem c) {
		v = new XTRElem[3];
		v[0] = a;
		v[1] = b;
		v[2] = c;
	}
	
	/**
	 * S<sub>n</sub> = (c<sub>n-1</sub>, c<sub>n</sub>, c<sub>n+1</sub>)
	 * @param modifier -1, 0 ou 1
	 * @return c<sub>n + modifier</sub>
	 */
	public XTRElem get(int modifier) {
		if (modifier < -1 || modifier > 1)
			return null;
		return v[modifier + 1];
	}
	
	/**
	 * 
	 * @param scalar
	 * @return (scalar * c<sub>n-1</sub>, scalar * c<sub>n</sub>, scalar * c<sub>n+1</sub>)
	 */
	public XTRTrincaElem scalarMul(BigInteger scalar) {
		XTRElem a = v[0].scalarMul(scalar);
		XTRElem b = v[1].scalarMul(scalar);
		XTRElem c = v[2].scalarMul(scalar);
		
		return new XTRTrincaElem(a, b, c);
	}
	
	public String toString() {
		return "(" + v[0] + ", " + v[1] + ", " + v[2] + ")";
 	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(v);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		XTRTrincaElem other = (XTRTrincaElem) obj;
		if (!Arrays.equals(v, other.v))
			return false;
		return true;
	}
	
	
}
