package tcc.haruki.domain;

import java.math.BigInteger;
import java.util.Random;

public class GaloisField {
	
	private BigInteger p;
	private Random random;
	
	public GaloisField(BigInteger p) {
		this.p = p;
		this.random = new Random();
	}
	
	public BigInteger val(BigInteger a) {
		return a.mod(p);
	}
	
	public BigInteger inverse(BigInteger a) {
		return a.modInverse(p);
	}
	
	public BigInteger add(BigInteger a, BigInteger b) {
		return (a.add(b)).mod(p);
	}
	
	public BigInteger mul(BigInteger a, BigInteger b) {
		return (a.multiply(b)).mod(p);
	}
	
	public BigInteger scalarExp(BigInteger a, BigInteger b) {
		return a.modPow(b, p);
	}
	
	public BigInteger getP() {
		return this.p;
	}
	
	public BigInteger randomElement() {
		return new BigInteger(this.p.bitLength(), this.random);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((p == null) ? 0 : p.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GaloisField other = (GaloisField) obj;
		if (p == null) {
			if (other.p != null)
				return false;
		} else if (!p.equals(other.p))
			return false;
		return true;
	}
}
