/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import usp.ime.line.ivprog.listeners.ICodeListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.For;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.workspace.IVPContainer;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.CodeBaseUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionFieldUI;
import usp.ime.line.ivprog.view.utils.IconButtonUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class ForUI
extends CodeBaseUI
implements ICodeListener {
    private JPanel contentPanel;
    private JPanel header;
    private IVPContainer container;
    private JButton expandBtnUP;
    private JButton expandBtnDOWN;
    private Icon up;
    private Icon down;
    private Icon dot;
    private Icon ellipsis;
    private Icon mode2;
    private String context;
    private JLabel codeBlockName;
    private JLabel timesLabel;
    private JLabel timesIncrementing;
    private JLabel oneByOne;
    private JLabel fromLbl;
    private JLabel upToLbl;
    private JLabel stepLbl;
    private JLabel lastParLbl;
    private JLabel codeBlockName_using;
    private ExpressionFieldUI lowerBoundField;
    private ExpressionFieldUI upperBoundField;
    private ExpressionFieldUI incrementField;
    private ExpressionFieldUI indexField;
    private ExpressionFieldUI mode_1and2_upperBound;
    private JButton btnLvl3;
    private JButton btnLvl2;
    private JButton btnLvl1;
    private int forMode = For.FOR_MODE_1;

    public ForUI(String string) {
        super(string);
        this.setModelID(string);
        this.initContentPanel();
        this.initExpandButtonIcon();
        this.initHeader();
        this.initExpressionHolder();
        this.initContainer();
        this.addContentPanel(this.contentPanel);
        this.setBackground(FlatUIColors.MAIN_BG);
        Services.getController().addComponentListener(this, string);
    }

    private void initContainer() {
        this.container = new IVPContainer(true, this.getModelID(), "");
        this.container.setContainerBackground(FlatUIColors.MAIN_BG);
        this.container.setVisible(false);
        this.contentPanel.add((Component)this.container, "Center");
    }

    private void initExpandButtonIcon() {
        this.up = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/expand_up.png"));
        this.down = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/expand_down.png"));
        this.dot = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/dot.png"));
        this.ellipsis = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/ellipsis.png"));
        this.mode2 = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/mode2.png"));
    }

    private void initContentPanel() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(false);
    }

    private void initHeader() {
        this.header = new JPanel(new FlowLayout(0));
        this.header.setOpaque(false);
        this.contentPanel.add((Component)this.header, "North");
        this.initExpandBtnUP();
        this.initExpandBtnDOWN();
        this.initExpression();
        this.initFieldsAndLabels();
        this.initCodeBlockLabel();
    }

    private void initExpressionHolder() {
    }

    private void initExpression() {
    }

    private void initExpandBtnUP() {
        this.expandBtnUP = new JButton();
        this.expandBtnUP.setIcon(this.up);
        this.expandBtnUP.setUI(new IconButtonUI());
        this.expandBtnUP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_EXPAND_CODE;");
                ForUI.this.expandedActions();
            }
        });
        this.expandBtnUP.setVisible(false);
        this.header.add(this.expandBtnUP);
    }

    private void initExpandBtnDOWN() {
        this.expandBtnDOWN = new JButton();
        this.expandBtnDOWN.setIcon(this.down);
        this.expandBtnDOWN.setUI(new IconButtonUI());
        this.expandBtnDOWN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CONTRACT_CODE;");
                ForUI.this.notExpandedAction();
            }
        });
        this.header.add(this.expandBtnDOWN);
    }

    protected void notExpandedAction() {
        this.container.setVisible(true);
        this.expandBtnUP.setVisible(true);
        this.expandBtnDOWN.setVisible(false);
        this.revalidate();
        this.repaint();
    }

    protected void expandedActions() {
        this.container.setVisible(false);
        this.expandBtnUP.setVisible(false);
        this.expandBtnDOWN.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    private void initFieldsAndLabels() {
        String string = ((For)Services.getModelMapping().get(this.getModelID())).getIndexExpression();
        this.initIndexField(string);
        this.codeBlockName = new JLabel(ResourceBundleIVP.getString("ForUI.for.text"));
        this.timesLabel = new JLabel(ResourceBundleIVP.getString("ForUI.times.text"));
        this.fromLbl = new JLabel(ResourceBundleIVP.getString("ForUI.from.text"));
        this.fromLbl.setVisible(false);
        this.initLowerBound();
        this.upToLbl = new JLabel(ResourceBundleIVP.getString("ForUI.upTo.text"));
        this.upToLbl.setVisible(false);
        this.initMode1UppderBound();
        this.initUpperBound();
        this.stepLbl = new JLabel(ResourceBundleIVP.getString("ForUI.step.text"));
        this.stepLbl.setVisible(false);
        this.initIncrementField();
        this.lastParLbl = new JLabel(ResourceBundleIVP.getString("ForUI.step2.text"));
        this.lastParLbl.setVisible(false);
        this.timesIncrementing = new JLabel(ResourceBundleIVP.getString("ForUI.timesIncrementing.text"));
        this.timesIncrementing.setVisible(false);
        this.oneByOne = new JLabel(ResourceBundleIVP.getString("ForUI.oneByOne.text"));
        this.oneByOne.setVisible(false);
        this.codeBlockName_using = new JLabel(ResourceBundleIVP.getString("ForUI.forUsing.text"));
        this.codeBlockName_using.setVisible(false);
        this.initBtns();
    }

    private void initBtns() {
        this.btnLvl3 = new JButton(this.ellipsis);
        this.btnLvl3.setUI(new IconButtonUI());
        this.btnLvl3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_FOR_BTNLVL3;");
                ForUI.this.level3Action();
            }
        });
        this.btnLvl3.setVisible(false);
        this.btnLvl2 = new JButton(this.mode2);
        this.btnLvl2.setUI(new IconButtonUI());
        this.btnLvl2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_FOR_BTNLVL2;");
                ForUI.this.level2Action();
            }
        });
        this.btnLvl2.setVisible(true);
        this.btnLvl1 = new JButton(this.dot);
        this.btnLvl1.setUI(new IconButtonUI());
        this.btnLvl1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_FOR_BTNLVL1;");
                ForUI.this.level1Action();
            }
        });
        this.btnLvl1.setVisible(false);
    }

    private void initMode1UppderBound() {
        this.mode_1and2_upperBound = new ExpressionFieldUI(this.getModelID(), this.getModelScope());
        this.mode_1and2_upperBound.setBlocked(false);
        this.mode_1and2_upperBound.setVisible(true);
        this.mode_1and2_upperBound.setHoldingType((short)13);
        this.mode_1and2_upperBound.setForHeader(true);
        this.mode_1and2_upperBound.hideMenu(true);
        this.mode_1and2_upperBound.setForContext("mode1_forUpperBound");
    }

    private void initIncrementField() {
        this.incrementField = new ExpressionFieldUI(this.getModelID(), this.getModelScope());
        this.incrementField.setBlocked(false);
        this.incrementField.setHoldingType((short)13);
        this.incrementField.setVisible(false);
        this.incrementField.setForHeader(true);
        this.incrementField.setForContext("forIncrement");
    }

    private void initUpperBound() {
        this.upperBoundField = new ExpressionFieldUI(this.getModelID(), this.getModelScope());
        this.upperBoundField.setBlocked(false);
        this.upperBoundField.setVisible(false);
        this.upperBoundField.setHoldingType((short)13);
        this.upperBoundField.setForHeader(true);
        this.upperBoundField.setForContext("forUpperBound");
    }

    private void initLowerBound() {
        this.lowerBoundField = new ExpressionFieldUI(this.getModelID(), this.getModelScope());
        this.lowerBoundField.setBlocked(false);
        this.lowerBoundField.setHoldingType((short)13);
        this.lowerBoundField.setVisible(false);
        this.lowerBoundField.setForHeader(true);
        this.lowerBoundField.setForContext("forLowerBound");
    }

    private void initIndexField(String string) {
        this.indexField = new ExpressionFieldUI(this.getModelID(), this.getModelScope());
        this.indexField.setBlocked(false);
        this.indexField.setHoldingType((short)13);
        this.indexField.setHolderContent(Services.getRenderer().paint(string));
        this.indexField.setVisible(false);
        this.indexField.setForHeader(true);
        this.indexField.hideMenu(true);
        this.indexField.setForContext("forIndex");
    }

    private void level3Action() {
        this.codeBlockName.setVisible(false);
        this.codeBlockName_using.setVisible(true);
        this.timesLabel.setVisible(false);
        this.indexField.setVisible(true);
        this.oneByOne.setVisible(false);
        this.mode_1and2_upperBound.setVisible(false);
        this.timesIncrementing.setVisible(false);
        this.fromLbl.setVisible(true);
        this.lowerBoundField.setVisible(true);
        this.upToLbl.setVisible(true);
        this.upperBoundField.setVisible(true);
        this.stepLbl.setVisible(true);
        this.incrementField.setVisible(true);
        this.lastParLbl.setVisible(true);
        this.btnLvl1.setVisible(true);
        this.btnLvl2.setVisible(false);
        this.btnLvl3.setVisible(false);
        Services.getController().changeForMode(For.FOR_MODE_3, this.getModelID());
        this.forMode = For.FOR_MODE_3;
    }

    private void level2Action() {
        this.codeBlockName.setVisible(true);
        this.codeBlockName_using.setVisible(false);
        this.timesLabel.setVisible(false);
        this.indexField.setVisible(true);
        this.oneByOne.setVisible(true);
        this.mode_1and2_upperBound.setVisible(true);
        this.timesIncrementing.setVisible(true);
        this.fromLbl.setVisible(false);
        this.lowerBoundField.setVisible(false);
        this.upToLbl.setVisible(false);
        this.upperBoundField.setVisible(false);
        this.stepLbl.setVisible(false);
        this.incrementField.setVisible(false);
        this.lastParLbl.setVisible(false);
        this.btnLvl1.setVisible(false);
        this.btnLvl2.setVisible(false);
        this.btnLvl3.setVisible(true);
        Services.getController().changeForMode(For.FOR_MODE_2, this.getModelID());
        this.forMode = For.FOR_MODE_2;
    }

    private void level1Action() {
        this.codeBlockName.setVisible(true);
        this.codeBlockName_using.setVisible(false);
        this.timesLabel.setVisible(true);
        this.mode_1and2_upperBound.setVisible(true);
        this.fromLbl.setVisible(false);
        this.indexField.setVisible(false);
        this.lowerBoundField.setVisible(false);
        this.upToLbl.setVisible(false);
        this.upperBoundField.setVisible(false);
        this.stepLbl.setVisible(false);
        this.incrementField.setVisible(false);
        this.lastParLbl.setVisible(false);
        this.btnLvl1.setVisible(false);
        this.btnLvl2.setVisible(true);
        this.btnLvl3.setVisible(false);
        Services.getController().changeForMode(For.FOR_MODE_1, this.getModelID());
        this.forMode = For.FOR_MODE_1;
    }

    private void initCodeBlockLabel() {
        this.header.add(this.codeBlockName_using);
        this.header.add(this.codeBlockName);
        this.header.add(this.mode_1and2_upperBound);
        this.header.add(this.timesIncrementing);
        this.header.add(this.indexField);
        this.header.add(this.oneByOne);
        this.header.add(this.fromLbl);
        this.header.add(this.lowerBoundField);
        this.header.add(this.upToLbl);
        this.header.add(this.upperBoundField);
        this.header.add(this.stepLbl);
        this.header.add(this.incrementField);
        this.header.add(this.lastParLbl);
        this.header.add(this.timesLabel);
        this.header.add(this.btnLvl3);
        this.header.add(this.btnLvl2);
        this.header.add(this.btnLvl1);
    }

    @Override
    public void setContext(String string) {
        this.context = string;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void addChild(String string, String string2) {
        this.container.addChild(string);
    }

    @Override
    public void childRemoved(String string, String string2) {
        this.container.childRemoved(string);
    }

    @Override
    public void restoreChild(String string, int n, String string2) {
        this.container.restoreChild(string, n);
    }

    @Override
    public void moveChild(String string, String string2, int n) {
        this.container.moveChild(string, n);
    }

    @Override
    public boolean isContentSet() {
        boolean bl = true;
        if (this.forMode == For.FOR_MODE_1) {
            if (!this.mode_1and2_upperBound.isContentSet()) {
                bl = false;
            }
        } else if (this.forMode == For.FOR_MODE_2) {
            if (!this.mode_1and2_upperBound.isContentSet()) {
                bl = false;
            }
            if (!this.indexField.isContentSet() && bl) {
                bl = false;
            }
        } else {
            if (!this.indexField.isContentSet() && bl) {
                bl = false;
            }
            if (!this.lowerBoundField.isContentSet() && bl) {
                bl = false;
            }
            if (!this.upperBoundField.isContentSet() && bl) {
                bl = false;
            }
            if (!this.incrementField.isContentSet() && bl) {
                bl = false;
            }
        }
        if (!this.container.isContentSet() && bl) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void lockDownCode() {
        this.indexField.setEdition(false);
        this.incrementField.setEdition(false);
        this.upperBoundField.setEdition(false);
        this.lowerBoundField.setEdition(false);
        this.mode_1and2_upperBound.setEdition(false);
        this.container.lockCodeDown();
    }
}

