/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.workspace.IVPContextMenu;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;

public class IVPContainer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Vector children;
    private boolean isInternalCanvas = false;
    private boolean isInternal = false;
    private String codeCompositeID;
    private IVPContextMenu menu;
    private String context;

    public IVPContainer(boolean bl, String string, String string2) {
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.isInternalCanvas = bl;
        this.children = new Vector();
        this.context = string2;
        this.codeCompositeID = string;
        this.initLayout();
        this.initialization();
        this.addMouseListener(Services.getML());
        this.addMouseMotionListener(Services.getML());
    }

    private void initialization() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                IVPContainer.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IVPContainer.this.requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
        this.menu = new IVPContextMenu(this, this.context);
        this.children.add(this.menu);
        this.relayout();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        this.setBackground(FlatUIColors.MAIN_BG);
        if (this.isInternalCanvas) {
            this.setPreferredSize(new Dimension(10, 30));
        }
    }

    public void relayout() {
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.removeAll();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(4, 3, 2, 5);
        this.initCanvasHeight();
        this.children.remove(this.menu);
        this.children.add(this.menu);
        for (int i = 0; i < this.children.size(); ++i) {
            gridBagConstraints.gridy = n++;
            JComponent jComponent = (JComponent)this.children.get(i);
            this.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n++;
        Component component = Box.createVerticalStrut(1);
        this.add(component, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    private void initCanvasHeight() {
        if (this.children.size() == 0) {
            this.setPreferredSize(new Dimension(10, 25));
        } else {
            this.setPreferredSize(null);
        }
    }

    public void removeChild(String string) {
        JComponent jComponent = (JComponent)Services.getViewMapping().get(string);
        this.children.remove(jComponent);
        this.relayout();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setChildren(Vector vector) {
        this.children = vector;
        this.relayout();
    }

    public void dropChild(JComponent jComponent, int n) {
        Vector vector = this.children;
        int n2 = n;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (int i = 0; i < vector.size(); ++i) {
            hashMap.put(new Integer(((JPanel)vector.get(i)).getY()), vector.get(i));
        }
        hashMap.put(new Integer(n2), jComponent);
        Vector vector2 = new Vector();
        vector2.addAll(hashMap.keySet());
        Collections.sort(vector2);
        Vector vector3 = new Vector();
        for (int i = 0; i < vector2.size(); ++i) {
            vector3.add(hashMap.get(vector2.get(i)));
        }
        vector.clear();
        vector.addAll(vector3);
        vector.add(vector.size(), this.menu);
        this.relayout();
    }

    public boolean isInternalCanvas() {
        return this.isInternalCanvas;
    }

    public String getCodeComposite() {
        return this.codeCompositeID;
    }

    public void setContainerBackground(Color color) {
        this.setBackground(FlatUIColors.MAIN_BG);
        this.revalidate();
        this.repaint();
    }

    public void addChild(String string) {
        JComponent jComponent = Services.getRenderer().paint(string);
        this.children.add(this.children.size() - 1, jComponent);
        this.relayout();
    }

    public void childRemoved(String string) {
        JComponent jComponent = (JComponent)Services.getViewMapping().get(string);
        this.children.remove(jComponent);
        this.relayout();
    }

    public void moveChild(String string, int n) {
        JComponent jComponent = (JComponent)Services.getViewMapping().get(string);
        int n2 = this.children.indexOf(jComponent);
        if (n >= n2) {
            this.children.add(n, jComponent);
            this.children.remove(n2);
        } else {
            this.children.remove(jComponent);
            this.children.add(n, jComponent);
        }
        this.relayout();
    }

    public void restoreChild(String string, int n) {
        JComponent jComponent = (JComponent)Services.getViewMapping().get(string);
        if (this.children.contains(jComponent)) {
            int n2 = this.children.indexOf(jComponent);
            if (n >= n2) {
                this.children.add(n, jComponent);
                if (n2 != -1) {
                    this.children.remove(n2);
                }
            } else {
                this.children.remove(jComponent);
                this.children.add(n, jComponent);
            }
        } else if (n != -1) {
            this.children.add(n, jComponent);
        } else {
            this.children.add(jComponent);
        }
        this.relayout();
    }

    public int getDropIndex(int n, JComponent jComponent) {
        int n2;
        this.children.remove(this.menu);
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            if (n >= ((JPanel)this.children.get(n2)).getY()) continue;
            if (n2 > 0 && jComponent.equals(this.children.get(n2 - 1))) {
                return n2 - 1;
            }
            return n2;
        }
        if (n2 > 0 && jComponent.equals(this.children.get(n2 - 1))) {
            return n2 - 1;
        }
        this.children.add(this.menu);
        return n2;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public boolean isContentSet() {
        boolean bl = true;
        for (int i = 0; i < this.children.size() - 1; ++i) {
            if (((IDomainObjectUI)this.children.get(i)).isContentSet() || !bl) continue;
            bl = false;
        }
        return bl;
    }

    public void lockCodeDown() {
        for (int i = 0; i < this.children.size() - 1; ++i) {
            ((IDomainObjectUI)this.children.get(i)).lockDownCode();
        }
    }
}

