/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.variables;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import usp.ime.line.ivprog.listeners.IValueListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Variable;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.editinplace.EditBoolean;
import usp.ime.line.ivprog.view.domaingui.editinplace.EditInPlace;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;
import usp.ime.line.ivprog.view.utils.IconButtonUI;
import usp.ime.line.ivprog.view.utils.RoundedJPanel;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class IVPVariableBasic
extends RoundedJPanel
implements IDomainObjectUI {
    private JPanel valueContainer;
    private JLabel equalLabel;
    private EditInPlace name;
    private EditInPlace value;
    private EditBoolean booleanValue;
    private JLabel valueLabel;
    private JPanel optionsContainer;
    private JButton configBtn;
    private JButton excludeBtn;
    protected String modelScopeID;
    protected String currentModelID;
    protected String parentModelID;
    private String context;
    private JPopupMenu configMenu;
    private Variable variable;

    public IVPVariableBasic(String string, String string2) {
        this.modelScopeID = string2;
        this.setBackgroundColor(FlatUIColors.MAIN_BG);
        this.initialization();
        this.setModelID(string);
    }

    private void initialization() {
        this.initLayout();
        this.initName();
        this.initEqualLabel();
        this.initValueContainer();
        this.initBooleanValueContainer();
        this.initOptionsContainer();
        this.initBtns();
        this.initConfigMenu();
        this.changeVariableType();
    }

    private void initLayout() {
        this.setOpaque(false);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(2);
        flowLayout.setVgap(2);
        flowLayout.setAlignment(0);
        this.setLayout(flowLayout);
    }

    private void initOptionsContainer() {
        this.optionsContainer = new JPanel();
        this.optionsContainer.setOpaque(false);
        FlowLayout flowLayout = (FlowLayout)this.optionsContainer.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        flowLayout.setAlignment(0);
        this.add(this.optionsContainer);
    }

    private void initBtns() {
        this.initConfigBtn();
        this.initDeleteBtn();
    }

    private void initDeleteBtn() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_DELETE_VARIABLE;");
                Services.getController().deleteVariable(IVPVariableBasic.this.modelScopeID, IVPVariableBasic.this.currentModelID);
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(IVPVariableBasic.class.getResource("/usp/ime/line/resources/icons/varDelete2.png")));
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("IVPVariableBasic.remove.tip"));
        this.excludeBtn = new JButton(abstractAction);
        this.excludeBtn.setUI(new IconButtonUI());
        this.optionsContainer.add(this.excludeBtn);
    }

    private void initConfigBtn() {
        this.configBtn = new JButton(new ImageIcon(IVPVariableBasic.class.getResource("/usp/ime/line/resources/icons/varConfig2.png")));
        this.configBtn.setUI(new IconButtonUI());
        this.configBtn.addActionListener(new ConfigBtnActionListener());
        this.optionsContainer.add(this.configBtn);
    }

    private void initConfigMenu() {
        this.configMenu = new JPopupMenu();
        ConfigTypeActionListener configTypeActionListener = new ConfigTypeActionListener();
        JMenuItem jMenuItem = new JMenuItem(ResourceBundleIVP.getString("IVPVariableBasic.config.integer"));
        this.configMenu.add(jMenuItem);
        jMenuItem.addActionListener(configTypeActionListener);
        JMenuItem jMenuItem2 = new JMenuItem(ResourceBundleIVP.getString("IVPVariableBasic.config.double"));
        this.configMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(configTypeActionListener);
        JMenuItem jMenuItem3 = new JMenuItem(ResourceBundleIVP.getString("IVPVariableBasic.config.string"));
        this.configMenu.add(jMenuItem3);
        jMenuItem3.addActionListener(configTypeActionListener);
        JMenuItem jMenuItem4 = new JMenuItem(ResourceBundleIVP.getString("IVPVariableBasic.config.boolean"));
        this.configMenu.add(jMenuItem4);
        jMenuItem4.addActionListener(configTypeActionListener);
    }

    private void initValueContainer() {
        this.value = new EditInPlace();
        this.value.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_INTEGER);
        this.value.setValue("1");
        this.value.setValueListener(new IValueListener(){

            @Override
            public void valueChanged(String string) {
                Services.getController().changeVariableInitialValue(IVPVariableBasic.this.currentModelID, string);
            }
        });
        this.add(this.value);
    }

    private void initBooleanValueContainer() {
        this.booleanValue = new EditBoolean();
        this.booleanValue.setValue("true");
        this.booleanValue.setValueListener(new IValueListener(){

            @Override
            public void valueChanged(String string) {
                Services.getController().changeVariableInitialValue(IVPVariableBasic.this.currentModelID, string);
            }
        });
        this.add(this.booleanValue);
    }

    private void initName() {
        this.name = new EditInPlace();
        this.name.setValueListener(new IValueListener(){

            @Override
            public void valueChanged(String string) {
                if (Services.getController().validateVariableName(IVPVariableBasic.this.modelScopeID, string)) {
                    Services.getController().changeVariableName(IVPVariableBasic.this.currentModelID, string);
                } else {
                    Variable variable = (Variable)Services.getModelMapping().get(IVPVariableBasic.this.currentModelID);
                    if (!variable.getVariableName().equals(string)) {
                        Services.getController().printError(ResourceBundleIVP.getString("Error.sameVariableName") + " " + string);
                    } else {
                        IVPVariableBasic.this.name.resetTextField();
                    }
                }
            }
        });
        this.name.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_NAME);
        this.add(this.name);
    }

    private void initEqualLabel() {
        this.equalLabel = new JLabel("=");
        this.add(this.equalLabel);
    }

    public void setVariableType(short s) {
        this.variable.setVariableType(s);
        this.changeVariableType();
    }

    public void setVariableName(String string) {
        this.name.setValue(string);
    }

    public void setVariableValue(String string) {
        this.value.setValue(string);
    }

    private void changeVariableType() {
        if (this.variable != null) {
            if (this.variable.getVariableType() == 13) {
                this.value.setVisible(true);
                this.value.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_INTEGER);
                this.value.setValue("1");
                this.booleanValue.setVisible(false);
            } else if (this.variable.getVariableType() == 14) {
                this.value.setVisible(true);
                this.value.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_DOUBLE);
                this.value.setValue("1.0");
                this.booleanValue.setVisible(false);
            } else if (this.variable.getVariableType() == 15) {
                this.value.setVisible(true);
                this.value.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_STRING);
                this.value.setValue(ResourceBundleIVP.getString("helloWorld.text"));
                this.booleanValue.setVisible(false);
            } else if (this.variable.getVariableType() == 16) {
                this.value.setVisible(false);
                this.booleanValue.setVisible(true);
                this.booleanValue.setValue("true");
            }
        }
    }

    @Override
    public String getModelID() {
        return this.currentModelID;
    }

    @Override
    public String getModelParent() {
        return this.parentModelID;
    }

    @Override
    public String getModelScope() {
        return this.modelScopeID;
    }

    @Override
    public void setModelID(String string) {
        this.currentModelID = string;
        this.variable = (Variable)Services.getModelMapping().get(string);
        this.changeVariableType();
    }

    @Override
    public void setModelParent(String string) {
        this.parentModelID = string;
    }

    @Override
    public void setModelScope(String string) {
        this.modelScopeID = string;
    }

    @Override
    public void setContext(String string) {
        this.context = string;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean isContentSet() {
        return true;
    }

    @Override
    public void lockDownCode() {
    }

    private class ConfigTypeActionListener
    implements ActionListener {
        private ConfigTypeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(ResourceBundleIVP.getString("IVPVariableBasic.config.integer"))) {
                Services.getController().changeVariableType(IVPVariableBasic.this.currentModelID, (short)13);
                IVPVariableBasic.this.changeVariableType();
                Tracking.track("event=CLICK;where=BTN_CHANGEVARTYPE_INT;");
            } else if (string.equals(ResourceBundleIVP.getString("IVPVariableBasic.config.double"))) {
                Services.getController().changeVariableType(IVPVariableBasic.this.currentModelID, (short)14);
                IVPVariableBasic.this.changeVariableType();
                Tracking.track("event=CLICK;where=BTN_CHANGEVARTYPE_DOUBLE;");
            } else if (string.equals(ResourceBundleIVP.getString("IVPVariableBasic.config.string"))) {
                Services.getController().changeVariableType(IVPVariableBasic.this.currentModelID, (short)15);
                IVPVariableBasic.this.changeVariableType();
                Tracking.track("event=CLICK;where=BTN_CHANGEVARTYPE_STRIN;");
            } else if (string.equals(ResourceBundleIVP.getString("IVPVariableBasic.config.boolean"))) {
                Services.getController().changeVariableType(IVPVariableBasic.this.currentModelID, (short)16);
                IVPVariableBasic.this.changeVariableType();
                Tracking.track("event=CLICK;where=BTN_CHANGEVARTYPE_BOOLEAN;");
            }
        }
    }

    private class ConfigBtnActionListener
    implements ActionListener {
        private ConfigBtnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IVPVariableBasic.this.configMenu.show(IVPVariableBasic.this.configBtn, 0, IVPVariableBasic.this.configBtn.getHeight());
            IVPVariableBasic.this.configMenu.requestFocus();
            Tracking.track("event=CLICK;where=BTN_CONFIG_VARIABLE;");
        }
    }
}

