/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.modules.assignment;

import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.assignment.model.DomainAction;
import ilm.framework.domain.DomainConverter;
import ilm.framework.domain.DomainModel;
import ilm.framework.modules.AssignmentModule;
import ilm.framework.modules.IlmModule;
import ilm.framework.modules.assignment.UndoRedoModuleToolbar;
import java.io.Serializable;
import java.util.Collection;
import java.util.Observable;
import java.util.Stack;
import java.util.Vector;

public class UndoRedoModule
extends AssignmentModule
implements Serializable {
    private Stack _undoStack = new Stack();
    private Stack _redoStack = new Stack();

    public UndoRedoModule() {
        this._name = "undo_redo";
        this._gui = new UndoRedoModuleToolbar();
        this._observerType = 1;
    }

    public void undo() {
        DomainAction domainAction = (DomainAction)((Stack)this._undoStack.get(this._assignmentIndex)).pop();
        ((Stack)this._redoStack.get(this._assignmentIndex)).push(domainAction);
        domainAction.undo();
    }

    public void redo() {
        DomainAction domainAction = (DomainAction)((Stack)this._redoStack.get(this._assignmentIndex)).pop();
        domainAction.setRedo(true);
        domainAction.execute();
    }

    public boolean isUndoStackEmpty() {
        return ((Stack)this._undoStack.get(this._assignmentIndex)).isEmpty();
    }

    public boolean isRedoStackEmpty() {
        return ((Stack)this._redoStack.get(this._assignmentIndex)).isEmpty();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof DomainAction) {
            DomainAction domainAction = (DomainAction)observable;
            if (domainAction.isUndo()) {
                this.setChanged();
                this.notifyObservers();
            } else {
                if (!domainAction.isRedo()) {
                    ((Stack)this._redoStack.get(this._assignmentIndex)).clear();
                }
                ((Stack)this._undoStack.get(this._assignmentIndex)).push((DomainAction)domainAction.clone());
                this.setChanged();
                this.notifyObservers();
            }
        }
    }

    @Override
    public void setContentFromString(DomainConverter domainConverter, int n, String string) {
        int n2;
        if (this._undoStack.size() == n && this._redoStack.size() == n) {
            this.addAssignment();
        }
        String string2 = this.getActions("undostack", string);
        String string3 = this.getActions("redostack", string);
        Vector vector = domainConverter.convertStringToAction(string2);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((Stack)this._undoStack.get(n)).push(vector.get(n2));
        }
        vector = domainConverter.convertStringToAction(string3);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((Stack)this._redoStack.get(n)).push(vector.get(n2));
        }
    }

    private String getActions(String string, String string2) {
        int n = string2.indexOf("<" + string + ">") + 2 + string.length();
        int n2 = string2.indexOf("</" + string + ">");
        if (n == -1 || n2 == -1) {
            return "";
        }
        String string3 = string2.substring(n, n2);
        return string3;
    }

    @Override
    public void addAssignment() {
        this._undoStack.add(new Stack());
        this._redoStack.add(new Stack());
    }

    @Override
    public void print() {
        for (int i = 0; i < this._undoStack.size(); ++i) {
            Stack stack = (Stack)this._undoStack.get(i);
            for (int j = 0; j < stack.size(); ++j) {
                DomainAction domainAction = (DomainAction)stack.get(j);
            }
        }
    }

    @Override
    public String getStringContent(DomainConverter domainConverter, int n) {
        if (((Stack)this._undoStack.get(n)).size() == 0 & ((Stack)this._redoStack.get(n)).size() == 0) {
            return "<" + this._name + "/>";
        }
        String string = "<" + this._name + ">";
        if (((Stack)this._undoStack.get(n)).size() > 0) {
            string = string + "<undostack>";
            string = string + domainConverter.convertActionToString((Vector)this._undoStack.get(n));
            string = string + "</undostack>";
        }
        if (((Stack)this._redoStack.get(n)).size() > 0) {
            string = string + "<redostack>";
            string = string + domainConverter.convertActionToString((Vector)this._redoStack.get(n));
            string = string + "</redostack>";
        }
        string = string + "</" + this._name + ">";
        return string;
    }

    @Override
    public void removeAssignment(int n) {
        this._undoStack.remove(n);
        this._redoStack.remove(n);
    }

    @Override
    public void setDomainModel(DomainModel domainModel) {
        DomainAction domainAction;
        int n;
        Stack stack;
        int n2;
        for (n2 = 0; n2 < this._undoStack.size(); ++n2) {
            stack = (Stack)this._undoStack.get(n2);
            for (n = 0; n < stack.size(); ++n) {
                domainAction = (DomainAction)stack.get(n);
                domainAction.setDomainModel(domainModel);
            }
        }
        for (n2 = 0; n2 < this._redoStack.size(); ++n2) {
            stack = (Stack)this._redoStack.get(n2);
            for (n = 0; n < stack.size(); ++n) {
                domainAction = (DomainAction)stack.get(n);
                domainAction.setDomainModel(domainModel);
            }
        }
    }

    @Override
    public void setState(AssignmentState assignmentState) {
        DomainAction domainAction;
        int n;
        for (n = 0; n < ((Stack)this._undoStack.get(this._undoStack.size() - 1)).size(); ++n) {
            domainAction = (DomainAction)((Stack)this._undoStack.get(this._undoStack.size() - 1)).get(n);
            domainAction.setState(assignmentState);
        }
        for (n = 0; n < ((Stack)this._redoStack.get(this._redoStack.size() - 1)).size(); ++n) {
            domainAction = (DomainAction)((Stack)this._redoStack.get(this._redoStack.size() - 1)).get(n);
            domainAction.setState(assignmentState);
        }
    }

    @Override
    public void setActionObservers(Collection collection) {
        for (IlmModule ilmModule : collection) {
            DomainAction domainAction;
            int n;
            Stack stack;
            int n2;
            if (!(ilmModule instanceof AssignmentModule)) continue;
            for (n2 = 0; n2 < this._undoStack.size(); ++n2) {
                stack = (Stack)this._undoStack.get(n2);
                for (n = 0; n < stack.size(); ++n) {
                    domainAction = (DomainAction)stack.get(n);
                    domainAction.addObserver((AssignmentModule)ilmModule);
                }
            }
            for (n2 = 0; n2 < this._redoStack.size(); ++n2) {
                stack = (Stack)this._redoStack.get(n2);
                for (n = 0; n < stack.size(); ++n) {
                    domainAction = (DomainAction)stack.get(n);
                    domainAction.addObserver((AssignmentModule)ilmModule);
                }
            }
        }
    }

    public void restoreFromFile() {
        for (int i = 0; i < this._redoStack.size(); ++i) {
            DomainAction domainAction;
            int n;
            Stack stack = (Stack)this._redoStack.get(i);
            for (n = 0; n < stack.size(); ++n) {
                domainAction = (DomainAction)stack.get(n);
                domainAction.executeInSilence();
            }
            for (n = 0; n < stack.size(); ++n) {
                domainAction = (DomainAction)stack.get(n);
                domainAction.undoInSilence();
            }
        }
    }
}

