/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.comm;

import ilm.framework.comm.ICommunication;
import ilm.framework.comm.IEncrypter;
import ilm.framework.comm.IlmAppletFileRW;
import ilm.framework.comm.IlmDesktopFileRW;
import ilm.framework.comm.IlmEncrypter;
import ilm.framework.config.SystemConfig;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipFile;

public class CommControl
implements ICommunication {
    private SystemConfig _config;
    private IEncrypter _encrypter;
    private ICommunication _fileRW;

    public CommControl(SystemConfig systemConfig) {
        this._config = systemConfig;
        this._encrypter = new IlmEncrypter();
        this._fileRW = this._config.isApplet() ? new IlmAppletFileRW() : new IlmDesktopFileRW();
    }

    @Override
    public String readMetadataFile(String string) {
        try {
            return this._fileRW.readMetadataFile(string);
        }
        catch (IOException iOException) {
            System.err.println("./ilm/framework/comm/CommControl.java: readMetadataFile(...): error " + iOException.toString());
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public Vector readResourceFiles(String string, Vector vector) {
        try {
            return this._fileRW.readResourceFiles(string, vector);
        }
        catch (IOException iOException) {
            System.err.println("./ilm/framework/comm/CommControl.java: readResourceFiles(...): error " + iOException.toString());
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public Vector readAssignmentFiles(String string, Vector vector) {
        try {
            return this._encrypter.decryptFromFile(this._fileRW.readAssignmentFiles(string, vector));
        }
        catch (IOException iOException) {
            System.err.println("./ilm/framework/comm/CommControl.java: readAssignmentFiles(...): error " + iOException.toString());
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public ZipFile writeAssignmentPackage(String string, String string2, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        try {
            return this._fileRW.writeAssignmentPackage(string, string2, vector, vector2, vector3, this._encrypter.encryptFileContent(vector4));
        }
        catch (IOException iOException) {
            System.err.println("./ilm/framework/comm/CommControl.java: writeAssignmentPackage(...): error " + iOException.toString());
            iOException.printStackTrace();
            return null;
        }
    }
}

