package tool;

import image.ImageView;

import java.awt.BorderLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import main.EyeOptions;

public class ImageToolBar extends JPanel{


	private static final long serialVersionUID = 1L;

	// path onde esta os botoes, futuramente mudar isso para ficar automatico para uma maquina generica
	String PATH_BUTTONS = getClass().getProtectionDomain().getCodeSource().getLocation().getPath() + "imagens/";

	// string com o path dos botoes
	protected String pathButtons;

	// toolbar
	protected JToolBar myToolBar;

	//botao clear
	protected JButton clearButton;
	
	//	botao rec
	protected JButton recButton;

	//icones do botao rec
	protected Icon recRed;
	protected Icon recGreen;
	
	// instancia do imageView
	protected ImageView imageView;

	//construtor
	public ImageToolBar(ImageView iv) {

		setLayout(new BorderLayout());

		myToolBar = new JToolBar();
		add(myToolBar, BorderLayout.NORTH);

		pathButtons = PATH_BUTTONS;

		imageView = iv;

		addImageButtons();
		
		System.out.println(PATH_BUTTONS);

	}

	// cria os botoes e os icones
	public void addImageButtons() {

		clearButton = addToolbarButton(myToolBar, true, null, "clear", "Clear");
		recButton = addToolbarButton(myToolBar, true, null, "rec", "Rec");
		
		recRed = new ImageIcon(pathButtons+ "rec" + ".gif");
		recGreen = new ImageIcon(pathButtons+ "stopRec" + ".gif");
		
		
		//myToolBar.add(recButton);

	}
	
	//muda o estado do botao rec
	public void changeButton() {
		String name = recButton.getName();
		
		if (name == "rec") {
			recButton.setIcon(recGreen);
			recButton.setName("stopRec");
			recButton.setToolTipText("StopRec");
			return;
		}
		
		if (name == "stopRec") {
			recButton.setIcon(recRed);
			recButton.setName("rec");
			recButton.setToolTipText("Rec");
			return;
		}
			
	}

	// muda o estado das opcoes
	public void changeRec() {

		EyeOptions eyeOptions = imageView.getEyeOptions();
		eyeOptions.setRecording(!eyeOptions.getRecording());

	}

	// Metodo auxliar para adicao de botoes
	public JButton addToolbarButton(JToolBar toolBar, boolean bUseImage,
			String sButtonText, String sButton, 
			String sToolHelp) {

		JButton button;

		// Crio um novo botao
		if (bUseImage) {
			
			Icon icon = new ImageIcon(pathButtons+ sButton + ".gif");

			button = new JButton(icon);
		}

		else
			button = (JButton) toolBar.add(new JButton());

		// Adicono o botao no toolbar
		toolBar.add(button);

		// Add optional button text
		if (sButtonText != null) {
			button.setText(sButtonText);
			button.setMargin(new Insets(0, 0, 0, 0));
		} else {
			// Only a graphic, so make the button smaller
			button.setMargin(new Insets(0, 0, 0, 0));
		}

		// Add optional tooltip help
		if (sToolHelp != null)
			button.setToolTipText(sToolHelp);

		button.setName(sButton);

		// Make sure this button sends a message when the user clicks it
		button.setActionCommand("Toolbar:" + sButton);
		// b.addActionListener( this );

		return button;
	}

}