package main;

import image.DisplayImage;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.awt.Point;

import javax.swing.JPanel;

import video.DisplayVideo;



public class ReceiveCoordenate extends Thread {
	public static final int PORT = 1111;
	
	public static final int STATUS = 0;
	public static final int X_COORD = 1;
	public static final int Y_COORD = 2;
	public static final int BUFFER_SIZE = 3;
	
	public static final int WIDTH = 1280;
	public static final int HEIGHT = 1024;
	
	public static final double OFFSET_X = 1.3;
	public static final double OFFSET_Y = 1.1;
	public static final double PIXELS_PER_CM_X = 37.9;  // 34 cm de largura
	public static final double PIXELS_PER_CM_Y = 37.2;  // 27.5 cm de altura
	
	public static byte [] byteBuffer = new byte[BUFFER_SIZE];
	public static int [] buffer = new int[BUFFER_SIZE];
	
	public static double totalWidthNorm, totalHeightNorm;
	
	private InputStream in;
	private OutputStream out;
	private static int  x ,y;
	private JPanel display;
	
	public ReceiveCoordenate(JPanel d)  {
		display = d;
	}
	
	public void run() {
		
		Socket socket = null;
		//boolean done = false;
		//while(!done){
		try{
			socket = new Socket("localhost", PORT);
			//done = true;
			System.out.println("Connected!");
			
			//Thread.sleep(100);
		}
		catch(java.net.ConnectException e){
		}
		catch(Exception e){
		}
		//}
		try {
			in = socket.getInputStream();
			out = socket.getOutputStream();
			
			
//			byte [] byteBuffer = new byte[BUFFER_SIZE];
//			int [] buffer = new int[BUFFER_SIZE];
			
			// Total width and height normalized 
			// 255 is the maximum width height from the eye tracker, using LED distance
			totalWidthNorm = (WIDTH + 2 * OFFSET_X * PIXELS_PER_CM_X)/255.0;
			totalHeightNorm = (HEIGHT + 2 * OFFSET_Y * PIXELS_PER_CM_Y)/255.0;
			
			while(in.read(byteBuffer) == byteBuffer.length){
				
				for(int i = 0; i < buffer.length; i++){
					buffer[i] = byteBuffer[i] & 0xFF;
					
				}
				
				// process data
				if(buffer[STATUS] > 0){
					
					x = (int)(totalWidthNorm * buffer[X_COORD] - OFFSET_X * PIXELS_PER_CM_X);
					y = (int)(totalHeightNorm * buffer[Y_COORD] - OFFSET_Y * PIXELS_PER_CM_Y);
					
					//System.out.println("gaze point: " + x + ", " + y);
					//bot.mouseMove((int)x, (int)y);
					 if(display.isDisplayable()) {
						 if (display instanceof DisplayImage) {
							 DisplayImage displayImage = (DisplayImage) display;
							 ((DisplayImage) displayImage).novaCoordenada((int)x - 
									 (int)((Point)displayImage.getLocationOnScreen()).getX(), (int)y - 
									 (int)((Point)displayImage.getLocationOnScreen()).getY());
						} 
						
						 else 
							 if (display instanceof DisplayVideo) {
								 DisplayVideo displayVideo = (DisplayVideo) display;
								 ((DisplayVideo) displayVideo).novaCoordenada((int)x - 
										 (int)((Point)displayVideo.getLocationOnScreen()).getX(), (int)y - 
										 (int)((Point)displayVideo.getLocationOnScreen()).getY());
							
							 }
					 }
				}
				else{
					//System.out.println("gaze point undefined.");
					//bot.mouseMove(WIDTH/2, HEIGHT/2);
					//dj.novaCoordenada(WIDTH/2, HEIGHT/2);
				}
				
				
			}
			
			in.close();
			out.close();
			socket.close();
		}
		catch(Exception e) {
			System.out.println(e.getMessage());
		}
	}
	
}
