package main;

import image.*;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.media.*;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;

import tool.ImageDynamicDeclineToolBar;
import tool.ImageDynamicToolBar;
import tool.ImageStaticToolBar;
import video.DisplayVideo;
import video.VideoView;
import videoTool.VideoDynamicDeclineToolbar;
import videoTool.VideoDynamicToolBar;
import videoTool.VideoStaticToolBar;
import videoTool.VideoToolBar;
import videoTool.ViewVideoToolBar;


public class EyeFrame extends JFrame implements ControllerListener {

	private static final long serialVersionUID = 1L;

//	classe q gerencia o Display
	private VideoView videoView;

	//	 main container
	private Container container;

	// guarda as opcoes do aplicativo
	private EyeOptions eyeOptions;

	// classe q gerencia o Display
	private ImageView imageView;

	// scrool q carrega o DisplayImage
	private JScrollPane jScroll;

	//JPanel
	private JPanel topPanel;


	public EyeFrame() {

		super("Ferramenta para Anlise do EyeTracker");

		// instancio o container
		container = getContentPane();

		//instancio as Opcoes
		eyeOptions = new EyeOptions();

		// instancio o imageView
		imageView = new ImageView(eyeOptions);

		//		 instancio o videoView
		videoView = new VideoView(eyeOptions);

		// Crio o menu
		initializeMenu();

		// instancio o jScroll com null
		jScroll = null;

		// instancio o topPanel com null
		topPanel = null;

		//defino um tamanho inicial default
		setSize(800, 600);
	}


	private void initializeMenu() {

		//instancio os Handlers
		RadioHandler radioHandler = new RadioHandler();
		MenuHandler  menuHandler  = new MenuHandler();
		CheckHandler checkHandler = new CheckHandler();

		//Menu mais externo    
		JMenuBar bar = new JMenuBar();
		setJMenuBar(bar);

		//Criando o Menu do "File"
		JMenu fileMenu = new JMenu("File");
		fileMenu.setMnemonic('F');

		//Criando o Menu do "Open"
		JMenu openMenu = new JMenu("Open");
		openMenu.setMnemonic('O');

		//Criando o Menu do "Image"
		JMenuItem openImage = new JMenuItem("Image");
		openImage.setMnemonic('I');

		//Adiciono o actionListener de abrir o arquivo
		openImage.addActionListener(menuHandler);

		//Criando o Menu do Video
		JMenuItem openVideo = new JMenuItem("Video");
		openVideo.setMnemonic('V');

		//Adiciono o actionListener de abrir o arquivo
		openVideo.addActionListener(menuHandler);

		//Criando o Menu Exit
		JMenuItem exitItem = new JMenuItem("Exit");
		exitItem.setMnemonic('x');

		//Adiciono o actionListner de sair
		exitItem.addActionListener(menuHandler);

		//Adiciono os itens no openMenu e o openMenu no fileMenu
		//Adiciono o exitMenu no openMenu
		openMenu.add(openImage);
		openMenu.add(openVideo);
		fileMenu.add(openMenu);
		fileMenu.add(exitItem);

		//adiciona o componente File na barra de menu.
		bar.add(fileMenu);

		//Criando os modos de visualizacao
		String filterStrings[] = { "Normal", "Binary", "Gaussian" };
		JMenu filterMenu = new JMenu("Spotlight");
		filterMenu.setMnemonic('t');

		JRadioButtonMenuItem filters[] = new JRadioButtonMenuItem[filterStrings.length];
		//ItemHandler itemHandler = new ItemHandler();
		ButtonGroup filterGroup = new ButtonGroup();

		//Adicionando os filtros com seus handlers
		for (int i = 0; i < filterStrings.length; i++) {
			filters[i] = new JRadioButtonMenuItem(filterStrings[i]);
			filterMenu.add(filters[i]);
			filterGroup.add(filters[i]);
			filters[i].addActionListener(radioHandler);
		}

		// por default o modo normal  selecionado a principio
		// Adiciono o filterMenu no bar
		filters[0].setSelected(true);
		bar.add(filterMenu);

		// Crio o Menu View
		JMenu viewMenu = new JMenu("View");
		viewMenu.setMnemonic('V');

		// Crio o checkBox para o fullScreen
		JCheckBoxMenuItem check = new JCheckBoxMenuItem("Full Screen");
		check.setMnemonic('F');

		// adiciono o check no view e o handler no check
		viewMenu.add(check);
		check.addActionListener(checkHandler);

		//adiciono o menu View no bar
		bar.add(viewMenu);

		//Criando os modos de visualizacao
		String toolsFilterStrings[] = { "Nothing", "Static", "Dynamic 1", "Dynamic 2" };
		JMenu toolsFilterMenu = new JMenu("Tools");
		toolsFilterMenu.setMnemonic('T');

		JRadioButtonMenuItem toolsFilters[] = new JRadioButtonMenuItem[toolsFilterStrings.length];
		//ItemHandler itemHandler = new ItemHandler();
		ButtonGroup toolsFilterGroup = new ButtonGroup();

		//Adicionando os filtros com seus handlers
		for (int i = 0; i < toolsFilterStrings.length; i++) {
			toolsFilters[i] = new JRadioButtonMenuItem(toolsFilterStrings[i]);
			toolsFilterMenu.add(toolsFilters[i]);
			toolsFilterGroup.add(toolsFilters[i]);
			toolsFilters[i].addActionListener(radioHandler);
		} 

		//por default nenhum modo de visualizao  selecionado a principio
		// Adiciono o filterMenu no bar
		toolsFilters[0].setSelected(true);
		bar.add(toolsFilterMenu);
	}

	//	classe interna anonima para tratar eventos de ao dos radios
	private class RadioHandler implements ActionListener {
		public void actionPerformed(ActionEvent event) {

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Normal") {
				System.out.println("Normal");

				eyeOptions.setViewOption(0);

				return;
			}

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Binary") {
				System.out.println("Binary");

				eyeOptions.setViewOption(1);

				return;
			}

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Gaussian") {
				System.out.println("Gaussian");

				eyeOptions.setViewOption(2);
				if (eyeOptions.getFileOption() == 2) {
					videoView.loadAndBufferGaussianInHD();
				}
				
				return;
			}

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Nothing") {
				System.out.println("Nothing");

				eyeOptions.setToolsOption(0);

				//removo o toolbar antigo
				if (topPanel != null ) {

					//forco ele a desaparecer!!!
					topPanel.setVisible(false);
					container.remove(topPanel);

				}

				if (eyeOptions.getFileOption() == 2) {

					topPanel = new ViewVideoToolBar(videoView);
					container.add(topPanel, BorderLayout.NORTH);

				}

				container.validate();

				return;
			}

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Static") {
				System.out.println("Static");

				eyeOptions.setToolsOption(1);

				// removo o topPanel antigo caso exista
				if (topPanel != null)
					container.remove(topPanel);

				//se o usuario nao abriu nenhum arquivo eu nao deixo abrir o toolBar
				if (eyeOptions.getFileOption() == 0)
					return;

				//crio um novo toolbar
				if (eyeOptions.getFileOption() == 1)
					topPanel = new ImageStaticToolBar(imageView);

				if (eyeOptions.getFileOption() == 2)
					topPanel = new VideoStaticToolBar(videoView);

				container.add(topPanel, BorderLayout.NORTH);
				container.validate();

				return;
			}

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Dynamic 1") {
				System.out.println("Dynamic 1");

				eyeOptions.setToolsOption(2);

				// removo o topPanel antigo caso exista
				if (topPanel != null)
					container.remove(topPanel);

				//se o usuario nao abriu nenhum arquivo eu nao deixo abrir o toolBar
				if (eyeOptions.getFileOption() == 0)
					return;

				//crio um novo toolbar
				if (eyeOptions.getFileOption() == 1)
					topPanel = new ImageDynamicToolBar(imageView); 

				if (eyeOptions.getFileOption() == 2)
					topPanel = new VideoDynamicToolBar(videoView);

				container.add(topPanel, BorderLayout.NORTH);
				container.validate();

				return;
			}

			if (((JRadioButtonMenuItem)event.getSource()).getText() == "Dynamic 2") {
				System.out.println("Dynamic 2");

				eyeOptions.setToolsOption(3);

				//removo o topPanel antigo caso exista
				if (topPanel != null)
					container.remove(topPanel);

				//se o usuario nao abriu nenhum arquivo eu nao deixo abrir o toolBar
				if (eyeOptions.getFileOption() == 0)
					return;

				//crio um novo toolbar
				if (eyeOptions.getFileOption() == 1)
					topPanel = new ImageDynamicDeclineToolBar(imageView);

				if (eyeOptions.getFileOption() == 2)
					topPanel = new VideoDynamicDeclineToolbar(videoView);

				container.add(topPanel, BorderLayout.NORTH);
				container.validate();

				return;
			}
		}
	}

	//	classe interna anonima para tratar eventos de ao dos menus
	private class MenuHandler implements ActionListener {
		public void actionPerformed(ActionEvent event) {

			File file = getFile();
			String path = "";

			if (file == null)
				return;

			// obtenho o path do file
			try {

				path = file.getAbsolutePath();

			} 
			catch (Exception e) {

				System.out.println(e);

			}

			System.out.println("Loading .... \n" + path);

			if (((JMenuItem)event.getSource()).getText() == "Image") {
				System.out.println("Image");

				eyeOptions.setFileOption(1);



				if (jScroll != null)
					container.remove(jScroll);

				jScroll = imageView.makeDisplayImage(path);
				container.add(jScroll, BorderLayout.CENTER);
				container.validate();

				return;
			}

			if (((JMenuItem)event.getSource()).getText() == "Video") {
				System.out.println("Video");

				//qdo for carregar um novo video eu seto todas as configuracoes iniciais
				eyeOptions.setFileOption(2);

				//removo o toolbar antigo
				if (topPanel != null ) {

					//forco ele a desaparecer!!!
					topPanel.setVisible(false);
					container.remove(topPanel);

				}

				//crio um painel simples para tocar o video
				topPanel = new ViewVideoToolBar(videoView);
				container.add(topPanel, BorderLayout.NORTH);
				container.validate();

				if (jScroll != null)
					container.remove(jScroll);


				jScroll = videoView.makeDisplayVideo(path);
				container.add(jScroll, BorderLayout.CENTER);
				container.validate();


				return;
			}

			if (((JMenuItem)event.getSource()).getText() == "Exit") {
				System.out.println("Exit");
				System.exit(0);
			}
		}
	}

//	classe interna anonima para tratar eventos de ao dos menus
	private class CheckHandler implements ActionListener {
		public void actionPerformed(ActionEvent event) {

			JCheckBoxMenuItem check = (JCheckBoxMenuItem)event.getSource();
			boolean full            =  eyeOptions.getFullScreen();

			if (check.getText() == "Full Screen") {
				System.out.println("Full Screen");

				if (!full) {
					fullScreen();
					full = true;
				}

				else {
					int lastW = eyeOptions.getLastWidth();
					int lastH = eyeOptions.getLastHeight();

					setSize(lastW, lastH);
					full = false;
				}

				eyeOptions.setFullScreen(full);

			}
		}
	}

	//	 Passa o programa para full screen
	// bug -> soh passa para o full screen a 1a vez..
	public void fullScreen() {

		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice gs = ge.getDefaultScreenDevice();
		gs.setFullScreenWindow(this);

	}

	// abro o arquivo escolhido pelo usuario
	public File getFile() {

		// instancio o fileChooser
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);

		// abro o fileChooser
		int result = fileChooser.showOpenDialog(this);

		// retorno o mediaFile
		if (result == JFileChooser.CANCEL_OPTION)
			return null;
		else
			return fileChooser.getSelectedFile();
	}

	public void controllerUpdate(ControllerEvent arg0) {
		// TODO Auto-generated method stub

	}

	public static void main(String args[]) {

		EyeFrame test = new EyeFrame();
		//testPlayer.setSize(800, 600);
		//testPlayer.setLocation(50, 50);
		//testPlayer.setDefaultCloseOperation(EXIT_ON_CLOSE);
		test.setVisible(true);
	}


}

/*
 // Java core packages

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.Controller;
import javax.media.ControllerAdapter;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.protocol.DataSource;
import javax.media.util.BufferToImage;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.Timer;




public class SimplePlayer extends JFrame implements ControllerListener , ActionListener {


    private static final long serialVersionUID = 1L;

    // Java media player
    private Player player;

    // main container
    private Container container;

    // media file and media locations
    private File mediaFile;

    private URL fileURL;

    private int currentFrame;

    private Long fr;

    private File file;

    private FileOutputStream writer;

    private PrintWriter printWriter;

    private PlanarImage image;

    private JScrollPane jScrollPane;

    private FrameGrabbingControl fg;

    boolean sessionOpen = false;

    private BufferedImage formatImg;

    private JRadioButtonMenuItem filters[];

    private DisplayJAIImage dj;

    private boolean full = false;

    private Timer timer;

    private int countDelay = 0;

    private ToolBar tool;

    private boolean rec = false;

    private ReceiveCoordenate rc;

    Object waitSync = new Object();

    private static boolean first = true;

    boolean stateTransitionOK = true;

    FramePositioningControl fpc;

    Time duration;

    int totalFrames;

    BufferedImage arrayBufferedImage[];





    // constructor for SimplePlayer
    public SimplePlayer() {
        super("Simple Java Media Player");
        container = getContentPane();
        initializeMenu();
        currentFrame = -1;

        file = new File("arquivo.txt");

        try {
            writer = new FileOutputStream(file, true);
            printWriter = new PrintWriter(writer, true);
            //printWriter.println("#Frames X Y Time");
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    } // end SimplePlayer constructor

    public SimplePlayer getInstance() {
        return this;
    }

    public File getMediaFile() {
        return mediaFile;
    }

    public void setMediaFile(File m) {
        mediaFile = m;
    }

    public DisplayJAIImage getDj() {
        return dj;
    }

    public File getfile() {
        return file;
    }

    public ToolBar getToolBar() {
        return tool;
    }


    public void initializeMenu() {

        // Menu mais externo ex: File    Edit    Refactor  Navigate
        JMenuBar bar = new JMenuBar();
        setJMenuBar(bar);

        // Criando o Menu do "File"
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');

        JMenu openMenu = new JMenu("Open");
        openMenu.setMnemonic('O');

        JMenuItem openImage = new JMenuItem("Image");
        openImage.setMnemonic('I');

        openImage.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent event) {
                String path = "";
                mediaFile = getFile();


                if (mediaFile != null) {

                    // obtain URL from file
                    try {
                        path = mediaFile.getAbsolutePath();
                    } catch (Exception e) {

                    }
                    System.out.println(path);

                    image = JAI.create("fileload", path);
                    if (dj != null) {
                        jScrollPane.remove(dj);
                        container.remove(jScrollPane);
                    }
                    dj = new DisplayJAIImage(image);
                    jScrollPane = new JScrollPane(dj);

                    if (jScrollPane != null) {
                        container.add(jScrollPane, BorderLayout.CENTER);
                        container.validate();
                        filters[0].setSelected(true);
                    }
                    if (first) { 
                        rc = new ReceiveCoordenate(dj, getInstance());
                        first = false;
                        rc.start();
                    }
                    else 
                        rc.setDj(dj);


                    if (player != null) {}
                        //removePlayerComponents();

                }
            } // end actionPerformed

        } // end ActionListener

        ); // end call to method addActionListener

        openMenu.add(openImage);

        JMenuItem openVideo = new JMenuItem("Video");
        openVideo.setMnemonic('V');

        openVideo.addActionListener(new ActionListener() {

            // open and create player for file
            public void actionPerformed(ActionEvent event) {
                mediaFile = getFile();

                if (mediaFile != null) {
                    setSize(800, 600);
                    // obtain URL from file
                    try {
                        fileURL = mediaFile.toURL();
                    }
                    // file path unresolvable
                    catch (MalformedURLException badURL) {
                        badURL.printStackTrace();
                        showErrorMessage("Bad URL");
                    }

                    makePlayer(fileURL.toString(), 1);

                    if (dj != null) {
                        jScrollPane.remove(dj);
                        container.remove(jScrollPane);
                    }
                    dj = new DisplayJAIImage(image);
                    jScrollPane = new JScrollPane(dj);

                    if (jScrollPane != null) {
                        container.add(jScrollPane, BorderLayout.CENTER);
                        container.validate();
                        filters[0].setSelected(true);
                    }

                   // if (jScrollPane != null){}
                        //removeImageComponents();

                   // thread1 = new VideoThread("clock", player, fr, duracao);
                    //thread1.start();

                }

            } // end actionPerformed

        });

        openMenu.add(openVideo);
        fileMenu.add(openMenu);

        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('x');

        //classe interna annima para tratar p evemtp exitItem
        exitItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });

        fileMenu.add(exitItem);

        //adiciona o componente File na barra de menu.
        bar.add(fileMenu);

        String filterStrings[] = { "Normal", "Binary", "Gaussian" };
        JMenu filterMenu = new JMenu("Spotlight");
        filterMenu.setMnemonic('t');

        filters = new JRadioButtonMenuItem[filterStrings.length];
        ItemHandler itemHandler = new ItemHandler();
        ButtonGroup filterGroup = new ButtonGroup();

        for (int i = 0; i < filterStrings.length; i++) {
            filters[i] = new JRadioButtonMenuItem(filterStrings[i]);
            filterMenu.add(filters[i]);
            filterGroup.add(filters[i]);
            filters[i].addActionListener(itemHandler);
        }

        filters[0].setSelected(true);
        bar.add(filterMenu);

        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');

        JCheckBoxMenuItem check = new JCheckBoxMenuItem("Full Screen");
        check.setMnemonic('F');
        viewMenu.add(check);
        check.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent event) {
                if (!full) {
                    fullScreen();
                    full = true;
                } else {
                    setSize(800, 600);
                    full = false;
                }
            }
        });

        bar.add(viewMenu);

        JCheckBoxMenuItem recorder = new JCheckBoxMenuItem("Table Rec");
        recorder.setMnemonic('T');
        viewMenu.add(recorder);
        tool = new ToolBar(container, getInstance());
        tool.SetVisibleToolBar(false);
        recorder.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent event) {

                if (rec) {
                    tool.SetVisibleToolBar(false);
                    rec = false;
                } else {
                    tool.SetVisibleToolBar(true);
                    rec = true;
                }
            }
        });

        bar.add(viewMenu);

        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic('T');

        JMenu dynamicMenu = new JMenu("Dynamic Tracker");
        dynamicMenu.setMnemonic('D');

        JMenuItem withCleaner = new JMenuItem("Whith Cleaner");

        JMenuItem noCleaner = new JMenuItem("no Cleaner");

        dynamicMenu.add(withCleaner);

        dynamicMenu.add(noCleaner);

        withCleaner.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                if(image == null && mediaFile == null) {
                    System.out.println("Abra uma imagem ou video em que deseja executar o dinamico!");
                    return;
                }
                tool.SetVisibleToolBar(true);
                getDj().setFilterType(4);
            }
        });

        noCleaner.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                if(image == null && mediaFile == null) {
                    System.out.println("Abra uma imagem ou video em que deseja executar o dinamico!");
                    return;
                }
                tool.SetVisibleToolBar(true);
                getDj().setFilterType(5);
                                Icon playIcon = new ImageIcon("/home/bcc/adal/work2/Player/play.gif");
                                 container.add(theDesktop);
                                 JInternalFrame frame = new JInternalFrame("Internal", true, true, true, true);
                                 Container c = frame.getContentPane();
                                 play = new JButton(playIcon);
                                 c.add(play);

                                 ButtonHandler b = new ButtonHandler();
                                 play.addActionListener(b);
                                 theDesktop.add(frame);

                                 frame.pack();
                                 frame.setVisible(true);
                                 theDesktop.setVisible(true);

            }
        });

        toolsMenu.add(dynamicMenu);

        JMenuItem staticMenu = new JMenuItem("Static Tracker");
        staticMenu.setMnemonic('S');
        staticMenu.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                tool.SetVisibleToolBar(true);
                getDj().setFilterType(3);
            }
        });
        toolsMenu.add(staticMenu);

        bar.add(toolsMenu);

    }

    // utility method for pop-up error messages
    public void showErrorMessage(String error) {
        JOptionPane.showMessageDialog(this, error, "Error",
                JOptionPane.ERROR_MESSAGE);
    }

    // Passa o programa para full screen
    public void fullScreen() {
        GraphicsEnvironment ge = GraphicsEnvironment
                .getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        gs.setFullScreenWindow(this);
    }

    // get file from computer
    public File getFile() {
        JFileChooser fileChooser = new JFileChooser();

        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        int result = fileChooser.showOpenDialog(this);

        if (result == JFileChooser.CANCEL_OPTION)
            return null;

        else
            return fileChooser.getSelectedFile();
    }

    public boolean saveFile() {
        JFileChooser fileChooser = new JFileChooser();
        int result = fileChooser.showSaveDialog(this);
        String path = fileChooser.getCurrentDirectory()
        + java.io.File.separator
                + fileChooser.getSelectedFile().getName();
        File saveFile = new File(path);
        if (result == JFileChooser.CANCEL_OPTION)
            return false;
        else if (result == JFileChooser.APPROVE_OPTION) {

            try {
                int arrlen = 10000000;
                byte[] infile = new byte[arrlen];
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                DataInputStream dis = new DataInputStream(bis);

                int filelength = dis.read(infile);
                String filestring = new String(infile, 0, filelength);
                writer = new FileOutputStream(saveFile, false);
                printWriter = new PrintWriter(writer, true);
                printWriter.println(filestring);
                writer.close();
            } catch (FileNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }
        return true;

    }

    //classe interna anonima para tratar eventos de ao dos itens de menu
    private class ItemHandler implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < filters.length; i++) {
                if (event.getSource() == filters[i]) {
                    dj.setFilterType(i);
                    break;
                }
            }
        }
    }

    public Player getPlayer() {
        return player;
    }

    public Container getContainer() {
        return container;
    }


    // create player using media's location
    public void makePlayer(String mediaLocation, int opcao) {
    	DataSource ds = null;

    	// Create a DataSource given the media locator.
    	try {
    	    ds = Manager.createDataSource(new MediaLocator(mediaLocation));
    	} catch (Exception e) {
    	    System.err.println("Cannot create DataSource from: " + mediaLocation);
    	    System.exit(0);
    	}


    	try {
    	    player = Manager.createPlayer(ds);
    	} catch (Exception e) {
    	    System.err.println("Failed to create a player from the given DataSource: " + e);
    	    return ;
    	}

    	player.addControllerListener(this);

    	player.realize();
    	if (!waitForState(player.Realized)) {
    	    System.err.println("Failed to realize the player.");
    	    return ;
    	}
    	(player.getVisualComponent()).setVisible(false);

    	// Try to retrieve a FramePositioningControl from the player.
    	fpc = (FramePositioningControl)player.getControl("javax.media.control.FramePositioningControl");

    	if (fpc == null) {
    	    System.err.println("The player does not support FramePositioningControl.");
    	    System.err.println("There's no reason to go on for the purpose of this demo.");
    	    return ;
    	}

//    	 create a frame grabber
    	 fg = 
    	    (FrameGrabbingControl) 
    	    player.getControl("javax.media.control.FrameGrabbingControl");

    	duration = player.getDuration();

    	if (duration != Duration.DURATION_UNKNOWN) {
    	    System.err.println("Movie duration: " + duration.getSeconds());

    	    totalFrames = fpc.mapTimeToFrame(duration);
    	    if (totalFrames != FramePositioningControl.FRAME_UNKNOWN)
    		System.err.println("Total # of video frames in the movies: " + totalFrames);
    	    else
    		System.err.println("The FramePositiongControl does not support mapTimeToFrame.");

    	} else {
    	    System.err.println("Movie duration: unknown"); 
    	}


    	// Prefetch the player.
    	player.prefetch();
    	if (!waitForState(player.Prefetched)) {
    	    System.err.println("Failed to prefetch the player.");
    	    return ;
    	}

    	 tool.SetVisibleToolBar(true);
         rec = true;

         arrayBufferedImage = new BufferedImage[totalFrames];
    	//timer = new Timer();
    	//task = new SyncImage();
    	//v = (long)(duration.getNanoseconds()/1000000)/totalFrames;
    	loadAndBufferVideo();
    }

 //   public void addNotify() {
   // 	super.addNotify();
    	//pack();
     //   }

    //da um load no video e guarda em um buffer
    //soh eh preciso passar este buffer p/ o display jai..
    //talvez seja melhor criar um outro construtor...
    //e qdo o usuario clicar em play...acionar uma thread q 
    //toca o video...para isto eh preciso implementar o SyncImage
         public void loadAndBufferVideo() {
    	int j = 1;
    	//arrayBufferedImage = new BufferedImage[totalFrames];
    	while(j < totalFrames) {
        //int dest = fpc.skip(1);
	    fpc.seek(j);
//	  take a snap of the current frame
	    Buffer buf = fg.grabFrame();    

//	     get its video format details
	    VideoFormat vf = (VideoFormat) buf.getFormat();

//	     initialize BufferToImage with video format
	    BufferToImage bufferToImage = 
	                          new BufferToImage(vf);



//	     convert the buffer to an image
	    BufferedImage im;
	    im = (BufferedImage) bufferToImage.createImage(buf);
	    BufferedImage bi = new BufferedImage(200, 200,
				BufferedImage.TYPE_INT_ARGB);

	    Graphics gi = bi.createGraphics();
	    ((Graphics2D)gi).drawImage(im, null, 0, 0);
	    TexturePaint texture = new TexturePaint(bi, new Rectangle2D.Double(0,0,200, 200));
	    BufferedImage bb = new BufferedImage(200, 200,
				BufferedImage.TYPE_INT_ARGB);

		Graphics gr = bb.createGraphics();
		((Graphics2D) gr).setPaint(texture);
		((Graphics2D) gr).fill(new Rectangle2D.Double(0,0,200, 200));
		im = bb;
	    arrayBufferedImage[j++] = im;
	    System.out.println(j);
    	}
    }




        //  Block until the player has transitioned to the given state.
        //  Return false if the transition failed.

        boolean waitForState(int state) {
    	synchronized (waitSync) {
    	    try {
    		while (player.getState() < state && stateTransitionOK)
    		    waitSync.wait();
    	    } catch (Exception e) {}
    	}
    	return stateTransitionOK;
        }


         // Controller Listener.

       public void controllerUpdate(ControllerEvent evt) {

    	if (evt instanceof ConfigureCompleteEvent ||
    	    evt instanceof RealizeCompleteEvent ||
    	    evt instanceof PrefetchCompleteEvent) {
    	    synchronized (waitSync) {
    		stateTransitionOK = true;
    		waitSync.notifyAll();
    	    }
    	} else if (evt instanceof ResourceUnavailableEvent) {
    	    synchronized (waitSync) {
    		stateTransitionOK = false;
    		waitSync.notifyAll();
    	    }
    	} else if (evt instanceof EndOfMediaEvent) {
    	    player.setMediaTime(new Time(0));
    	    //p.start();
    	    //p.close();
    	    //System.exit(0);
    	} else if (evt instanceof SizeChangeEvent) {
    	}
        }

    public static void main(String args[]) {

        SimplePlayer testPlayer = new SimplePlayer();
        testPlayer.setSize(800, 600);
        testPlayer.setLocation(50, 50);
        //testPlayer.setDefaultCloseOperation(EXIT_ON_CLOSE);
        testPlayer.setVisible(true);
    }


	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub

	}



} // end class SimplePlayer

 */
