package image;

import javax.swing.JScrollPane;

import main.*;

public class ImageView  {
	
	private String path;
	
	private EyeOptions eyeOptions;
	
	private DisplayImage displayImage;
	
	public ImageView(EyeOptions eo) {
		eyeOptions = eo;
	}
	
	public JScrollPane makeDisplayImage(String p) {
		String path = p;
		displayImage = new DisplayImage(path, eyeOptions);
		
		JScrollPane jScroll = new JScrollPane(displayImage);
		
		return jScroll;
	}
	
	public void viewStatic() {
	
		if (eyeOptions.getFileOption() == 1)
			displayImage.displayStatic();
		else 
			System.out.println("Abra uma Imagem!!");
		
	}
	
	public void clear() {
		if (eyeOptions.getFileOption() == 1)
			displayImage.clearImage();
		else 
			System.out.println("Abra uma Imagem!!");
	}
	
	public void closeWriter() {
		displayImage.closeWriter();
	}
	
	public void setPath(String p) {
		path = p;
	}
	
	public String getPath() {
		return path;
	}
	
	public void setEyeOptions(EyeOptions eo) {
		eyeOptions = eo;
	}
	
	public EyeOptions getEyeOptions() {
		return eyeOptions;
	}
	
	

}
