package image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;

public class ImageProcessor {
	
	// dimensoes da imagem ou video
	//private int width;
	//private int height;
	
	// Texturas para as imagens
	private TexturePaint textureOriginal;
	private TexturePaint textureGaussian1;
	private TexturePaint textureGaussian2;
	
	// Buffers auxiliares
	private BufferedImage bufferGaussian1;
	private BufferedImage bufferGaussian2;
	private BufferedImage bufferBlack;
	private BufferedImage bufferGray;
	
	
	// Shapes auxliares
	private Ellipse2D ellipse2D;
	
	//constantes
	public static final int MASK_SIZE1 = 5; // tamanho da mascara 1
	public static final int MASK_SIZE2 = 15;// tamanho da mascara 2
	
	public ImageProcessor() {
		
	}
	
	// construtor para imagens
	public ImageProcessor(BufferedImage bi) {
		//width  = w;
		//height = h;

		ellipse2D = null;
		
		createInstanceOfTexturesBuffers(bi);
	}
	
	// cria uma textura a partir de bufferedImage
	public TexturePaint createTexture(BufferedImage bi) {
		
		return (new TexturePaint(bi, new Rectangle2D.Double(0, 0, bi.getWidth(), bi.getHeight())));

	}
	
	// faz a convolucao do buffer bi usando uma mascara de tamanho sizeMask
	public BufferedImage makeConvolve(BufferedImage bi, int sizeMask) {
	
		// mascara a ser usada
		float mask[];
		
		// instancio a mascara
		mask = new float[sizeMask * sizeMask];
		
		// preeencho a mascara com 1.0f/sizeMask^2
		for (int k = 0; k < mask.length; k++)
			mask[k] = 1.0f / (sizeMask * sizeMask);
		
		//crio o kernel jai
		KernelJAI kernel = new KernelJAI(sizeMask, sizeMask, mask);
		
		// efetuo a operacao convolve e armazeno o resultado em um planar Image
		PlanarImage planarConv = JAI.create("convolve", bi, kernel);
		
		// transformo o planarImage em um bufferedImage
		BufferedImage conv = planarConv.getAsBufferedImage();
		
		return conv;
			
	}
	
	//cria as instancias das texturas e dos buffers
	public void createInstanceOfTexturesBuffers(BufferedImage bi) {
		BufferedImage original   = bi;
		bufferGaussian1 = makeConvolve(original, MASK_SIZE1);
		bufferGaussian2 = makeConvolve(original, MASK_SIZE2);
		bufferBlack     = createBlackBuffer(original);
		
		textureOriginal  = createTexture(original);
		textureGaussian1 = createTexture(bufferGaussian1);
		textureGaussian2 = createTexture(bufferGaussian2);
		
	}
	
	// cria o buffer com fundo preto
	//  melhor armzenar em um buffer o fundo para otimizar 
	// a visualizacao do paint
	public BufferedImage createBlackBuffer(BufferedImage bi) {
		BufferedImage bp = new BufferedImage(bi.getWidth(), bi.getHeight(),
				BufferedImage.TYPE_INT_ARGB);
		
		Graphics gr = bp.createGraphics();
		gr.setColor(Color.black);
		gr.fillRect(0, 0, bp.getWidth(), bp.getHeight());

		return bp;
	}
	
	// Devolve um circulo com centro x e y e r de raio
	public Ellipse2D setPositionOfEllipse(int x, int y, int r) {
		
		if (ellipse2D == null)
			
			return new Ellipse2D.Double(x, y, r, r);
		
		else {
		
			ellipse2D.setFrame(x, y, r, r);
			return ellipse2D;
		
		}
	}
	
	public TexturePaint getTextureOriginal() {
		return textureOriginal;
	}
	
	public TexturePaint getTextureGaussian1() {
		return textureGaussian1;
	}
	
	public TexturePaint getTextureGaussian2() {
		return textureGaussian2;
	}
	
	public BufferedImage getBufferGaussian1() {
		return bufferGaussian1;
	}
	
	public BufferedImage getBufferGaussian2() {
		return bufferGaussian2;
	}
	
	public BufferedImage getBufferBlack() {
		return bufferBlack;
	}
	public BufferedImage getBuffer(String type) {
		if (type.compareTo("black") == 0)
			return bufferBlack;
		else 
			return bufferGray;
		
	}
	
	
	

}
