package videoTool;

import java.awt.BorderLayout;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import main.EyeOptions;

import video.VideoView;


public class VideoToolBar extends JPanel {

	private static final long serialVersionUID = 1L;
	
//	 path onde esta os botoes, futuramente mudar isso para ficar automatico para uma maquina generica
	//protected static final String PATH_BUTTONS = "C:\\Documents and Settings\\Adalberto\\workspace\\imagens\\";
	String PATH_BUTTONS = getClass().getProtectionDomain().getCodeSource().getLocation().getPath() + "imagens/";

	// string com o path dos botoes
	protected String pathButtons;

	// toolbar
	protected JToolBar myToolBar;
	
	//botao volta
	protected JButton rew;
	
	//botao rec
	protected JButton rec;
	
	//botao play e pause
	protected JButton go;
	
	//botao stop
	protected JButton stop;
	
	//botao ff
	protected JButton ff;
	
	//	icones do botao rec
	protected Icon recRed;
	protected Icon recGreen;
	
	//icones do botao play e pause
	protected Icon play;
	protected Icon pause;
	
	//videoView
	protected VideoView videoView;
	
	public VideoToolBar(VideoView vv) {
		
		setLayout(new BorderLayout());

		myToolBar = new JToolBar();
		add(myToolBar, BorderLayout.NORTH);

		pathButtons = PATH_BUTTONS;

		videoView = vv;

		addImageButtons();
		
	}
	
//	 Metodo auxliar para adicao de botoes
	public JButton addToolbarButton(JToolBar toolBar, boolean bUseImage,
			String sButtonText, String sButton, 
			String sToolHelp) {

		JButton button;

		// Crio um novo botao
		if (bUseImage) {
			
			Icon icon = new ImageIcon(pathButtons+ sButton + ".gif");

			button = new JButton(icon);
		}

		else
			button = (JButton) toolBar.add(new JButton());

		// Adicono o botao no toolbar
		toolBar.add(button);

		// Add optional button text
		if (sButtonText != null) {
			button.setText(sButtonText);
			button.setMargin(new Insets(0, 0, 0, 0));
		} else {
			// Only a graphic, so make the button smaller
			button.setMargin(new Insets(0, 0, 0, 0));
		}

		// Add optional tooltip help
		if (sToolHelp != null)
			button.setToolTipText(sToolHelp);

		button.setName(sButton);

		// Make sure this button sends a message when the user clicks it
		button.setActionCommand("Toolbar:" + sButton);
		// b.addActionListener( this );

		return button;
	}
	
//	muda o estado do botao rec
	public void changeButtonRec() {
		String name = rec.getName();
		
		if (name == "rec") {
			rec.setIcon(recGreen);
			rec.setName("stopRec");
			rec.setToolTipText("StopRec");
			return;
		}
		
		if (name == "stopRec") {
			rec.setIcon(recRed);
			rec.setName("rec");
			rec.setToolTipText("Rec");
			return;
		}
			
	}
	
//	muda o estado do botao rec
	public void changeButtonGo() {
		String name = go.getName();
		
		
		if (name == "play") {
			go.setIcon(pause);
			go.setName("pause");
			go.setToolTipText("play");
			return;
		}
		
		if (name == "pause") {
			go.setIcon(play);
			go.setName("play");
			go.setToolTipText("pause");
			return;
		}
			
	}

//	 muda o estado das opcoes
	public void changeRec() {

		EyeOptions eyeOptions = videoView.getEyeOptions();
		eyeOptions.setRecording(!eyeOptions.getRecording());

	}
	
//	 cria os botoes e os icones
	public void addImageButtons() {

		//cria e adiciona os botoes
		rew = addToolbarButton(myToolBar, true, null, "rew", "Rew");
		rec = addToolbarButton(myToolBar, true, null, "rec", "Rec");
		go = addToolbarButton(myToolBar, true, null, "play", "Play");
		stop = addToolbarButton(myToolBar, true, null, "stop", "stop");
		ff = addToolbarButton(myToolBar, true, null, "ff", "Ff");
		
		//cria os icones
		recRed = new ImageIcon(pathButtons+ "rec" + ".gif");
		recGreen = new ImageIcon(pathButtons+ "stopRec" + ".gif");
		play = new ImageIcon(pathButtons+ "play" + ".gif");
		pause = new ImageIcon(pathButtons+ "pause" + ".gif");

	}
	
}
