package video;


import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import main.EyeOptions;

public class VideoView {

	private EyeOptions eyeOptions;

	private DisplayVideo displayVideo;

	public VideoView(EyeOptions eo) {
		eyeOptions = eo;
	}
	
	public JScrollPane makeDisplayVideo(String p) {
		String path = p;
		displayVideo = new DisplayVideo(path, eyeOptions);
		
		JScrollPane jScroll = new JScrollPane(displayVideo);
		
		return jScroll;
	}
	
	public void loadAndBufferGaussianInHD() {
		if ( !displayVideo.getVideoInfo().gaussianLoaded) {
			displayVideo.loadAndBufferGaussianInHD();
			displayVideo.getVideoInfo().gaussianLoaded = true;
		}
	}
	
	public void closeWriter() {
		displayVideo.closeWriter();
	}
	
	public void play(Icon play, JToolBar myToolBar) {
		displayVideo.play(play, myToolBar);
	}
	
	public void pause() {
		displayVideo.pause();
	}
	
	public void rew() {
		displayVideo.rew();
	}
	
	public void stop() {
		displayVideo.stop();
	}
	
	public void ff() {
		displayVideo.ff();
	}
	
	public EyeOptions getEyeOptions() {
		return eyeOptions;
	}


}
