package video;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class VideoProcessor {
	private BufferedImage blackBuffer;
	
	
	// Texturas para as imagens
	private TexturePaint textureOriginal;
	private TexturePaint textureGaussian1;
	private TexturePaint textureGaussian2;
	
	//Buffers auxiliares
	private BufferedImage bufferGaussian1;
	private BufferedImage bufferGaussian2;
	
	// Shapes auxliares
	private Ellipse2D ellipse2D;
	
	public VideoProcessor() {
	
		blackBuffer = null;
		
	}
	
	public void setBlackBuffer(int width, int height) {
		
		blackBuffer = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		Graphics gr = blackBuffer.getGraphics();
		((Graphics2D )gr).setPaint(Color.BLACK);
		((Graphics2D) gr).fill(new Rectangle2D.Double(0,0,width, height));
		
	}
	
	//cria uma textura a partir de bufferedImage
	public TexturePaint createTexture(BufferedImage bi) {
		
		return (new TexturePaint(bi, new Rectangle2D.Double(0, 0, bi.getWidth(), bi.getHeight())));
		
	}
	
//	 Devolve um circulo com centro x e y e r de raio
	public Ellipse2D setPositionOfEllipse(int x, int y, int r) {
		
		if (ellipse2D == null)
			
			return new Ellipse2D.Double(x, y, r, r);
		
		else {
		
			ellipse2D.setFrame(x, y, r, r);
			return ellipse2D;
		
		}
	}
	
	
	public BufferedImage getBlackBuffer() {
		return blackBuffer;
	}
}
