package video;

import gaze.GazeIdentifier;
import image.DeclineFixations;
import image.ImageProcessor;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.util.BufferToImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.Timer;

import tool.WriterReaderData;


import main.EyeOptions;
import main.ReceiveCoordenate;

public class DisplayVideo extends JPanel implements MouseMotionListener, ControllerListener, ActionListener{

	private static final long serialVersionUID = 1L;

	//classpath do projeto
	String PATH = getClass().getProtectionDomain().getCodeSource().getLocation().getPath();

	//opcoes
	private EyeOptions eyeOptions;

	//BufferedImage atual
	private BufferedImage current;

//	BufferedImage atual
	private BufferedImage maskBuffer;

	//BufferedImage para as imagens convoluidas
	private BufferedImage gaussian1;
	private BufferedImage gaussian2;
	
//	alpha para implementar o decaimento
	private AlphaComposite alphaDecline;
	
	private DeclineFixations declineFixations;

	//Timer para sicrnizacao do video
	private Timer timerTask;

	//centro deslocado para o circulo
	private int centerX;
	private int centerY;
	private int lastCenterX;
	private int lastCenterY;

	//classe auxiliar para escrever os dados no arquivo
	// soh para o tool static
	private WriterReaderData writerReaderData;

	//	 indentificador de fixacoes
	private GazeIdentifier gazeIdentifier;

	//	 alpha para desenho das fixacoes
	private AlphaComposite alphaComposite;
	
	//linha do arquivo
	private String lineFile;


	/////////////////////////////////////////////////
	//atributos do jmf para manipulao de video

	//player
	private Player player;

	//controle de posicao
	private FramePositioningControl fpc;

	//objeto que tem acesso aos frames
	private FrameGrabbingControl fg;

	//data source
	private DataSource ds;

	//objeto de sincronizacao
	private Object waitSync;

	//confirma o estado de transicao
	private boolean stateTransitionOK;

	//processa as imagens do video
	private VideoProcessor videoProcessor;

	//guarda as informacoes sobre o videeo
	private VideoInfo videoInfo;

	//cte q representa o raio do circulo
	private static final int RAIO_CIRCLE = 100;

	//	 o quanto  perdido da imagem devido a uma convoluo gaussiana
	private static final int GAUSSIAN_BORDER = 7;
	
	ReceiveCoordenate receiveCoordenate;

	
	/**
	 * A vesao atual  uma versao usando o mouse como entrada
	 * Usado para testes
	 * Para usar uma versao com entrada usando o EyeTracking  necessario descomentar as ultimas 
	 * linhas do construtor
	 */


	//contrutor
	public DisplayVideo(String p, EyeOptions eo) {

		String path = "file:" + p;

		waitSync = new Object();

		stateTransitionOK = true;

		eyeOptions = eo;

		videoInfo = new VideoInfo();

		videoProcessor = new VideoProcessor();

		writerReaderData = new WriterReaderData();
		
		alphaComposite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER);

		gazeIdentifier = new GazeIdentifier();

		fpc = null;

		fg = null;

		initAll(path);

		videoInfo.nameVideo = parserNameVideo(path);
		
		declineFixations = new DeclineFixations();

		makePlayer(ds);

		loadAndBufferInHD();

		if (eyeOptions.getViewOption() == 2) {
			loadAndBufferGaussianInHD();
			videoInfo.gaussianLoaded = true;
		}

		addMouseMotionListener(this);
		
		
		/*
		 * Para Rodar usando o EyeTracking
		 * 
		 * receiveCoordenate = new ReceiveCoordenate(this);
		 * receiveCoodenate.start();
		 * 
		 */
		

	}

	//parsei o nome do path ... retornonado apenas o nome do video sem .mov
	public String parserNameVideo(String path) {
		System.out.println(path);
		String[] tokenPath = path.split("/");
		System.out.println(tokenPath[0]);
		tokenPath = tokenPath[tokenPath.length - 1].split("\\.");
		System.out.println(tokenPath[0]);
		return tokenPath[0];
	}

	public void mouseDragged(MouseEvent arg0) {
		// TODO Auto-generated method stub

	}

	//implementacao do metodo de mover o mouse
	public void mouseMoved(MouseEvent e) {
		int gr;
		double cx, cy;


		centerX = e.getX() - RAIO_CIRCLE / 2;
		centerY = e.getY() - RAIO_CIRCLE / 2;

//		indentifica a fixacao e verifica se esta no estado fixo
		gazeIdentifier.identifyGaze(e.getX() + " " + e.getY());
		gr = gazeIdentifier.checkFix();

		// se ocorreu fixacao o gazeIdentifier devolve um inteiro que 
		// representa o grupo fixo, cc devolve -1
		if (gr != -1) {

			//obtenho o centro do grupo fixo
			cx = gazeIdentifier.centerX[gr];
			cy = gazeIdentifier.centerY[gr];

			tool((int)cx, (int)cy);

			repaint();
		}

	}
	
//	implementacao do metodo de mover o mouse
	public void novaCoordenada(int x, int y) {
		int gr;
		double cx, cy;


		centerX = x - RAIO_CIRCLE / 2;
		centerY = y - RAIO_CIRCLE / 2;

//		indentifica a fixacao e verifica se esta no estado fixo
		gazeIdentifier.identifyGaze(x + " " + y);
		gr = gazeIdentifier.checkFix();

		// se ocorreu fixacao o gazeIdentifier devolve um inteiro que 
		// representa o grupo fixo, cc devolve -1
		if (gr != -1) {

			//obtenho o centro do grupo fixo
			cx = gazeIdentifier.centerX[gr];
			cy = gazeIdentifier.centerY[gr];

			tool((int)cx, (int)cy);

			repaint();
		}

	}

//	desenha o tool estatico na tela
	// faz a iteracao aqui mesmo, pois assim nao eh necessario criar
	// uma lista para depois iterar
	public String displayStatic(String line) {
		
		if (line == null)
			return null;

		String[] parser = line.split(" ");
		//crio a regra de composicao de alpha

		if (alphaComposite.getAlpha() != 0.1)
			alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.1);

		//inic o ultimo elemento com -1
		int lastx = -1;
		int lasty = -1;
		int cx;
		int cy;

		// enquanto a existir linhas no arquivo
		while(Integer.parseInt(parser[2]) < videoInfo.frame) {

			System.out.println(line);
			
			cx = Integer.parseInt(parser[0]);
			cy = Integer.parseInt(parser[1]);

			//desenho o ponto
			paintStaticToolMask(lastx, lasty, Integer.parseInt(parser[0]), Integer.parseInt(parser[1]), alphaComposite);

			lastx = cx;
			lasty = cy;

			line = writerReaderData.readNextLine();
			if (line == null) 
				return line;
			parser = line.split(" ");
		}
		
		return line;

}

//	 metodo que desenha usando o metodo estatico
public void paintStaticToolMask(int lastx, int lasty, int x, int y, AlphaComposite ac) {
	if (maskBuffer == null)
		maskBuffer = new BufferedImage(current.getWidth(), current.getHeight(),
				BufferedImage.TYPE_INT_ARGB);
	Graphics g = maskBuffer.getGraphics();

	// obtenho o grafico do toolBuffer e seto o alpha composite

	((Graphics2D) g).setComposite(ac);
	((Graphics2D) g).setPaint(Color.red);

	//desenho a linha se nao for a 1a
	if (lastx != -1 && lasty != -1) 
		g.drawLine(lastx, lasty, x, y);

	//desenho o circulo
	((Graphics2D) g).fill(new Ellipse2D.Double(x - 5, y - 5, 10, 10));

}

//faz as respectivas operacoes para a coordenada x e y
public void tool(int centerX, int centerY) {
	int tool = eyeOptions.getToolsOption();

	switch(tool) {

	case 0:
		break;
	case 1:

		if (eyeOptions.getRecording()) {
			writerReaderData.writeInFile(centerX, centerY, videoInfo.frame);
		}

		break;
	case 2:
		if (eyeOptions.getRecording()) {
			displayDynamic(centerX, centerY, lastCenterX, lastCenterY);

			lastCenterX = centerX;
			lastCenterY = centerY;

		}
		else {
			reSetLast();
		}

		break;
	case 3:
		
		if (eyeOptions.getRecording()) {

			displayDynamicDeclineList(centerX, centerY, lastCenterX, lastCenterY);
			lastCenterX = centerX;
			lastCenterY = centerY;

		}
		else {

			reSetLast();

		}
		
		break;
	}
}

//desenha o dinamico com dedcaimento usando uma lista dinamica
public void displayDynamicDeclineList(int centerX, int centerY, int lastX, int lastY) {

	declineFixations.addPoint(new Point(centerX, centerY));
	declineFixations.removePoint();

	//Big gambiarra, para o binario utilizo a mascara de fixacoes pois esta obteve uma visualizacao mais suave
	//(ou menos pior) !!! Para os outros utilizo a mascara de fixacoes
	Graphics g;

	maskBuffer = new BufferedImage(current.getWidth(), current.getHeight(),
			BufferedImage.TYPE_INT_ARGB);

	g = maskBuffer.getGraphics();


	//itero sobre a lista de fixacoes
	float i = ((float)0.5/(float)declineFixations.fixations.size());
	int lastx = -1;
	int lasty = -1;
	int j = 1;
	for (Point p : declineFixations.fixations) {

		alphaDecline = AlphaComposite.getInstance(alphaComposite.getRule(), (float) i*j);
		((Graphics2D) g).setComposite(alphaDecline);

		((Graphics2D) g).setPaint(Color.red);

		//desenho a linha se nao for a 1a
		if (lastx != -1 && lastx != -1) 
			g.drawLine(lastx, lasty, p.x, p.y);

		//		desenho o circulo
		((Graphics2D) g).fill(new Ellipse2D.Double(p.x - 5, p.y - 5, 10, 10));

		lastx = p.x;
		lasty = p.y;

		j++;
	}

}

//restarta o last para -1
public void reSetLast() {

	if (lastCenterX == -1)
		return;
	else {
		lastCenterX = -1;
		lastCenterY = -1;
	}

}

//desenha o dinamico sem decaimento
public void displayDynamic(int centerX, int centerY, int lastX, int lastY) {
	
	if (maskBuffer == null)
		maskBuffer = new BufferedImage(current.getWidth(), current.getHeight(),
				BufferedImage.TYPE_INT_ARGB);

	Graphics g = maskBuffer.getGraphics();

	if (alphaComposite.getAlpha() != 0.1)
		alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.1);

	// obtenho o grafico do toolBuffer e seto o alpha composite
	//Graphics g = toolBuffer.getGraphics(); 
	((Graphics2D) g).setComposite(alphaComposite);
	((Graphics2D) g).setPaint(Color.red);

	//desenho a linha se nao for a 1a
	if (lastX != -1 && lastY != -1) 
		g.drawLine(lastX, lastY, centerX, centerY);

	//		desenho o circulo
	((Graphics2D) g).fill(new Ellipse2D.Double(centerX - 5, centerY - 5, 10, 10));

	repaint();
}


//fecha o escritor
public void closeWriter() {

	writerReaderData.closeWriter();

}

//processa o proximo frame e devolve um bufferedImage do frame atual
public BufferedImage processImage(BufferedImage current) {

	//take a snap of the current frame
	javax.media.Buffer buf = fg.grabFrame();    

	//get its video format details
	VideoFormat vf = (VideoFormat) buf.getFormat();

	//initialize BufferToImage with video format
	BufferToImage bufferToImage = new BufferToImage(vf);

	//convert the buffer to an image
	current = (BufferedImage) bufferToImage.createImage(buf);

	return current;
}

public void paint(Graphics g) {

	switch(eyeOptions.getViewOption()) {
	case(0):
		((Graphics2D)g).drawImage(current, null, 0, 0);
	break;
	case(1):

		if (videoProcessor.getBlackBuffer() == null)
			videoProcessor.setBlackBuffer(current.getWidth(), current.getHeight());

	((Graphics2D)g).drawImage(videoProcessor.getBlackBuffer(), null, 0, 0);

	((Graphics2D)g).setPaint(new TexturePaint(current,new Rectangle2D.Double(0,0, current.getWidth(), current.getHeight())));

	((Graphics2D)g).fill(new Ellipse2D.Double(centerX, centerY, RAIO_CIRCLE, RAIO_CIRCLE));


	//preenche a parte da tela que no contm imagem (moldura cinza)			
	g.setColor(Color.LIGHT_GRAY);
	// lado direito da moldura
	((Graphics2D) g).fillRect(current.getWidth(), 0, 1152 - current.getWidth(), current.getHeight());
	//lado esquerdo da moldura
	((Graphics2D) g).fillRect(0, current.getHeight(), 1152, 864 - current.getHeight());

	break;
	case(2):
		//			Gaussiano

		if (gaussian1 != null) {

			// desenho o buffer convoluido com a maior mascara
			((Graphics2D) g).drawImage(gaussian2, null, 0, 0);

			//obtenho a textura do buffer convoluido com a menor mascara
			((Graphics2D) g).setPaint(videoProcessor.createTexture(gaussian1));

			//preencho o circulo de buffer convoluido com a menor mascara
			((Graphics2D) g).fill(videoProcessor.setPositionOfEllipse(centerX - RAIO_CIRCLE, centerY - RAIO_CIRCLE, 3*RAIO_CIRCLE));

			//obtenho a textura do buffer com a imagem original
			((Graphics2D) g).setPaint(videoProcessor.createTexture(current));

			//preencho o circulo com o buffer original
			((Graphics2D) g).fill(videoProcessor.setPositionOfEllipse(centerX, centerY, RAIO_CIRCLE));

//			(moldura cinza) preenche a parte da tela que no contm imagem 
			g.setColor(Color.LIGHT_GRAY);
			// lado direito da moldura
			((Graphics2D) g).fillRect(current.getWidth()- GAUSSIAN_BORDER, 0, 1152 - current.getWidth() , current.getHeight());
			// parte inferior da moldura
			((Graphics2D) g).fillRect(0, current.getHeight()- GAUSSIAN_BORDER, 1152, 864 - current.getHeight());
			//lado esquerdo da moldura
			((Graphics2D) g).fillRect(0, 0, GAUSSIAN_BORDER, 864);
			//parte superior da moldura
			((Graphics2D) g).fillRect(0, 0, 1152, GAUSSIAN_BORDER);


		}
	break;
	}
	switch(eyeOptions.getToolsOption()) {
	case(0):
		//((Graphics2D)g).drawImage(current, null, 0, 0);
		break;
	case(1):
		((Graphics2D)g).drawImage(current, null, 0, 0);
		((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);
	case(2):
		((Graphics2D)g).drawImage(current, null, 0, 0);
		((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);
	case(3):
		((Graphics2D)g).drawImage(current, null, 0, 0);
		((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);
	}

}

//inicializa tudo
public void initAll(String path) {

	MediaLocator ml;

	if ((ml = new MediaLocator(path)) == null) {
		System.err.println("Cannot build media locator from: " + path);
		System.exit(0);
	}

	ds = null;

	// Create a DataSource given the media locator.
	try {
		ds = Manager.createDataSource(ml);
	} catch (Exception e) {
		System.err.println("Cannot create DataSource from: " + ml);
		System.exit(0);
	}

}

//metodo q cria o player em si..mas nao toca a midia
public void makePlayer(DataSource ds) {

	System.err.println("create player for: " + ds.getContentType());

	try {
		player = Manager.createPlayer(ds);
	} catch (Exception e) {
		System.err.println("Failed to create a player from the given DataSource: " + e);
		System.exit(0);
	}

	player.addControllerListener(this);

	player.realize();
	if (!waitForState(player.Realized)) {
		System.err.println("Failed to realize the player.");
		System.exit(0);
	}


	//Try to retrieve a FramePositioningControl from the player.
	fpc = (FramePositioningControl)player.getControl("javax.media.control.FramePositioningControl");

	if (fpc == null) {
		System.err.println("The player does not support FramePositioningControl.");
		System.err.println("There's no reason to go on for the purpose of this demo.");
		System.exit(0);
	}

	//create a frame grabber
	fg = (FrameGrabbingControl) 
	player.getControl("javax.media.control.FrameGrabbingControl");

	Time duration = player.getDuration();

	if (duration != Duration.DURATION_UNKNOWN) {
		System.err.println("Movie duration: " + duration.getSeconds());

		videoInfo.totalFrames = fpc.mapTimeToFrame(duration);
		if (videoInfo.totalFrames != FramePositioningControl.FRAME_UNKNOWN)
			System.err.println("Total # of video frames in the movies: " + videoInfo.totalFrames);
		else
			System.err.println("The FramePositiongControl does not support mapTimeToFrame.");

	} else {
		System.err.println("Movie duration: unknown"); 
	}

	videoInfo.frameRate = (int) ((duration.getNanoseconds()/1000000)/videoInfo.totalFrames);

	//Prefetch the player.
	player.prefetch();
	if (!waitForState(player.Prefetched)) {
		System.err.println("Failed to prefetch the player.");
		System.exit(0);
	}

	//seto o frame incial para 0
	videoInfo.frame = 0;

	//instancio o timerTask
	timerTask = new Timer(videoInfo.frameRate, new PlayHandler());
}

/**
 * Block until the player has transitioned to the given state.
 * Return false if the transition failed.
 */
boolean waitForState(int state) {
	synchronized (waitSync) {
		try {
			while (player.getState() < state && stateTransitionOK)
				waitSync.wait();
		} catch (Exception e) {}
	}
	return stateTransitionOK;
}

/**
 * Controller Listener.
 */
public void controllerUpdate(ControllerEvent evt) {

	if (evt instanceof ConfigureCompleteEvent ||
			evt instanceof RealizeCompleteEvent ||
			evt instanceof PrefetchCompleteEvent) {
		synchronized (waitSync) {
			stateTransitionOK = true;
			waitSync.notifyAll();
		}
	} else if (evt instanceof ResourceUnavailableEvent) {
		synchronized (waitSync) {
			stateTransitionOK = false;
			waitSync.notifyAll();
		}
	} else if (evt instanceof EndOfMediaEvent) {
		player.setMediaTime(new Time(0));
		//p.start();
		//p.close();
		//System.exit(0);
	} else if (evt instanceof SizeChangeEvent) {
	}
}

public void addNotify() {
	super.addNotify();
	//pack();
}

//avanca para o proximo frame...no momento nao esta sendo usado
public void advFrame() {
	if (videoInfo.frame > videoInfo.totalFrames) {

		stop();
		changeToPause();
	}
	else {

		videoInfo.frame++;

		fpc.seek(videoInfo.frame);

		current = processImage(current);
	}

	repaint();
}

//avanca para o proximo frame lendo do HD
public void advFrameFromHD() {

	if (videoInfo.frame >= videoInfo.totalFrames) {

		finished();
		changeToPause();
		clear();
		return;
	}
	else {

		//fpc.seek(videoInfo.frame);

		current = loadFromHD(videoInfo.frame, "");

		videoInfo.frame++;
	}

	repaint();
}

//avanca para o proximo frame lendo do HD
public void advFrameGaussianFromHD() {

	if (videoInfo.frame >= videoInfo.totalFrames) {

		finished();
		changeToPause();
		clear();
		return;
	}
	else {

		//fpc.seek(videoInfo.frame);

		current = loadFromHD(videoInfo.frame, "");
		gaussian1 = loadFromHD(videoInfo.frame, "convolve1/");
		gaussian2 = loadFromHD(videoInfo.frame, "convolve2/");

		videoInfo.frame++;
	}

	repaint();
}


//le do HD o frame e devolve um BufferedImage
public BufferedImage loadFromHD(int frame, String extension) {
	BufferedImage image = null;

	try {
		image = ImageIO.read( new File( PATH + videoInfo.nameVideo + "/" + extension + frame + ".jpg" ) );
	} catch (IOException e) {

		e.printStackTrace();
	}
	return image;
}

//atualiza o frame
public void repaintFrame() {


	current = loadFromHD(videoInfo.frame, "");
	if (eyeOptions.getViewOption() == 2 ) {
		gaussian1 = loadFromHD(videoInfo.frame, "convolve1/");
		gaussian2 = loadFromHD(videoInfo.frame, "convolve2/");
	}

	repaint();
}

//precessa todos os frames e armazena no HD
public void loadAndBufferInHD() {

	BufferedImage buffer = null;

	boolean success = (new File(PATH +  videoInfo.nameVideo)).mkdir();
	if (success) {
		System.out.println("Directory: " + PATH +  videoInfo.nameVideo + " created");
	}

	for(int i = 0; i < videoInfo.totalFrames; i++) {

		fpc.seek(i);


		buffer = processImage(buffer);

		FileOutputStream fos;
		try {

			boolean exists = (new File(PATH +  videoInfo.nameVideo + "/" + i + ".jpg")).exists();
			if (exists) {
				System.out.println("EXISTS=" + PATH + videoInfo.nameVideo + "/" + i + ".jpg");
			} else {

				System.out.println("LOADING=" + PATH + videoInfo.nameVideo + "/" + i + ".jpg");

				fos = new FileOutputStream(PATH +  videoInfo.nameVideo + "/" + i + ".jpg");
				ImageIO.write(buffer,"JPEG", fos);

			}


		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {				
			e.printStackTrace();
		}	
	}
}

//obtem os BufferedImages do HD e cria imagens convoluidas e armazana no HD
public void loadAndBufferGaussianInHD() {

	BufferedImage buffer = null;
	BufferedImage buffer1 = null;
	BufferedImage buffer2 = null;

	ImageProcessor imageProcessor = new ImageProcessor();

	boolean success = (new File(PATH +  videoInfo.nameVideo + "/convolve1")).mkdir();
	if (success) {
		System.out.println("Directory: " + PATH +  videoInfo.nameVideo + "convolve1" + " created");
	}

	success = (new File(PATH +  videoInfo.nameVideo + "/convolve2")).mkdir();
	if (success) {
		System.out.println("Directory: " + PATH +  videoInfo.nameVideo + "convolve2" + " created");
	}

	for(int i = 0; i < videoInfo.totalFrames; i++) {

		buffer = loadFromHD(i, "");

		buffer1 = imageProcessor.makeConvolve(buffer, ImageProcessor.MASK_SIZE1);
		buffer2 = imageProcessor.makeConvolve(buffer, ImageProcessor.MASK_SIZE2);

		FileOutputStream fos;
		try {

			boolean exists = (new File(PATH +  videoInfo.nameVideo + "/" + "convolve1/" + i + ".jpg")).exists();
			if (exists) {
				System.out.println("EXISTS=" + PATH + videoInfo.nameVideo + "/" + "convolve1/" + i + ".jpg");
			} else {

				System.out.println("LOADING=" + PATH + videoInfo.nameVideo + "/" + "convolve1/" + i + ".jpg");

				fos = new FileOutputStream(PATH +  videoInfo.nameVideo + "/" + "convolve1/" + i + ".jpg");
				ImageIO.write(buffer1,"JPEG", fos);
			}

			exists = (new File(PATH +  videoInfo.nameVideo + "/" + "convolve2/" + i + ".jpg")).exists();
			if (exists) {
				System.out.println("EXISTS=" + PATH + videoInfo.nameVideo + "/" + "convolve2/" + i + ".jpg");
			} else {

				System.out.println("LOADING=" + PATH + videoInfo.nameVideo + "/" + "convolve2/" + i + ".jpg");

				fos = new FileOutputStream(PATH +  videoInfo.nameVideo + "/" + "convolve2/" + i + ".jpg");
				ImageIO.write(buffer2,"JPEG", fos);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {				
			e.printStackTrace();
		}	
	}
}
public String paintff(String line) {
	
	
	if (line == null)
		return null;

	String[] parser = line.split(" ");
	//crio a regra de composicao de alpha

	if (alphaComposite.getAlpha() != 0.1)
		alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.1);

	//inic o ultimo elemento com -1
	int lastx = -1;
	int lasty = -1;
	int cx;
	int cy;

	// enquanto a existir linhas no arquivo
	while(Integer.parseInt(parser[2]) < videoInfo.frame) {

		System.out.println(line);
		
		cx = Integer.parseInt(parser[0]);
		cy = Integer.parseInt(parser[1]);

		//desenho o ponto
		paintStaticToolMask(lastx, lasty, Integer.parseInt(parser[0]), Integer.parseInt(parser[1]), alphaComposite);

		lastx = cx;
		lasty = cy;

		line = writerReaderData.readNextLine();
		if (line == null) 
			return null;
		parser = line.split(" ");
	}
	
	return line;

	
}

public void play(Icon play, JToolBar myToolBar) {
	videoInfo.iconAux = play;
	videoInfo.myToolBar = myToolBar;
	
	if (eyeOptions.getToolsOption() == 1)
		lineFile = writerReaderData.readNextLine();

	timerTask.setInitialDelay(0);
	timerTask.start();
}

//muda o estado do video para pausado
public void changeToPause() {
	JToolBar myToolBar = videoInfo.myToolBar;
	JButton go = null;
	
	for (java.awt.Component comp : myToolBar.getComponents()) {
		if (comp.getName().equals("pause"))
			go = (JButton) comp;
	}
	
	go.setName("play");
	go.setIcon(videoInfo.iconAux);
}

//pausa o video
public void pause() {
	timerTask.stop();
}

public void finished() {
	timerTask.stop();
	videoInfo.frame = 0;
	if (writerReaderData.getReader() != null)
		writerReaderData.closeReader();
}

//reinicia o video
public void rew() {
	videoInfo.frame = videoInfo.frame - 20;

	if(videoInfo.frame < 0)
		videoInfo.frame = 0;

	repaintFrame();
}

//para o video
public void stop() {
	timerTask.stop();
	videoInfo.frame = 0;
	clear();
	repaintFrame();
	if (writerReaderData.getReader() != null)
		writerReaderData.closeReader();
}

//avancao o video7
public void ff() {
	videoInfo.frame = videoInfo.frame + 20;
	if (videoInfo.frame > videoInfo.totalFrames - 1)
		videoInfo.frame = videoInfo.totalFrames - 1;
	repaintFrame();
}

//limpa o video
public void clear() {
	current = loadFromHD(videoInfo.frame, "");
	maskBuffer = new BufferedImage(current.getWidth(), current.getHeight(),
			BufferedImage.TYPE_INT_ARGB);
}

//handler do timer
private class PlayHandler implements ActionListener  {
	public void actionPerformed(ActionEvent evt) {
		if (eyeOptions.getViewOption() != 2)
			advFrameFromHD();
		else
			advFrameGaussianFromHD();
		
		if (eyeOptions.getToolsOption() == 1 && lineFile != null)
			lineFile = displayStatic(lineFile);
	}
};

public void actionPerformed(ActionEvent arg0) {
	// TODO Auto-generated method stub

}

public VideoInfo getVideoInfo() {
	return videoInfo;
}

public void setVideoInfo(VideoInfo videoInfo) {
	this.videoInfo = videoInfo;
}

}
