package tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class WriterReaderData {

	//	 arquivo de amostras
	private static final String OUTPUT_FILE = "EyeData.txt";

	// atributos para a impressao de dados
	private FileOutputStream writer;
	private PrintWriter printWriter;

	//atributos para leitura de dados
	private BufferedReader reader;

	// verifica se o arquivo esta aberto para escrita esta aberto
	private boolean writeOpen;

	//verifica se o arquivo para leitura estar aberto
	private boolean readerOpen;

	public WriterReaderData() {

	}

	//fecha o arquivo para o escritor
	public void closeWriter() {
		try {

			writer.close();
			printWriter.close();
			writeOpen = false;

		} 
		catch (IOException e) {

			e.printStackTrace();

		}
	}

	public void initReaderValues() {
		try {

			reader = new BufferedReader(new FileReader(new File(OUTPUT_FILE)));
			readerOpen = true;
			
		} 
		catch (FileNotFoundException e) {

			e.printStackTrace();

		}

	}

	public String readNextLine() {
		if (!readerOpen)
			initReaderValues();

		String line = null;
		
		try {

			line = reader.readLine();
			
		} 
		catch (IOException e) {

			e.printStackTrace();
		}
		
		return line;
	}
	
//	fecha o arquivo para o leitor
	public void closeReader() {
		try {

			reader.close();
			readerOpen = false;

		} 
		catch (IOException e) {

			e.printStackTrace();

		}
	}

	//inicia valores para o escritor
	public void initWriterValues() {

		try {

			File file = new File(OUTPUT_FILE);
			writer = new FileOutputStream(file, false);
			printWriter = new PrintWriter(writer, true);
			writeOpen = true;

		}
		catch (FileNotFoundException e) {

			e.printStackTrace();
		}
	}

	//escreve no arquivo
	public void writeInFile(int centerX, int centerY ) {
		if (writer == null)
			initWriterValues();
		else {
			if (writeOpen)
				printWriter.println(centerX + " " + centerY);
			else {
				initWriterValues();
				writeInFile(centerX, centerY);
			}
		}
	}
	
	//escreve no arquivo para video pois relaciona a posicao com o frame corrente
	public void writeInFile(int centerX, int centerY, int frame) {
		if (writer == null)
			initWriterValues();
		else {
			if (writeOpen)
				printWriter.println(centerX + " " + centerY + " " + frame);
			else {
				initWriterValues();
				writeInFile(centerX, centerY, frame);
			}
		}
	}


	//verifica se o arquivo esta aberto
	public boolean writeOpen() {
		return writeOpen;
	}

	public BufferedReader getReader() {
		return reader;
	}

	public void setReader(BufferedReader reader) {
		this.reader = reader;
	}



}
