package main;

public class EyeOptions {
	
	// 0 se nenhum arquivo foi carregado
	// 1 se for imagem
	// 2 se for video
	private int fileOption;
	
	// 0 se for carregar no modo normal (default)
	// 1 se for carregar no modo binario
	// 2 se for carregar no gaussiano
	private int viewOption;
	
	// true se o aplicativo estiver usando tela cheia(default)
	// false cc.
	private boolean fullScreen;
	
	// 0 sem nenhum efeito
	// 1 com rastremento estatico
	// 2 com rastreamento dinamico com decaimento
	// 3 com rastreamento dinamico sem decaimento
	private int toolsOption;
	
	// guarda as Dimensoes da imagem ou video atual
	private int height;
	private int width;
	
	// serve para guardar as dimessoes depois de dar fullScreen
	private int lastHeight;
	private int lastWidth;
	
	private boolean recording;
	
	public EyeOptions() {
		fileOption  = 0;
		viewOption  = 0;
		fullScreen  = false;
		toolsOption = 0;
		width       = 800;
		height      = 600;
		lastWidth   = width;
		lastHeight  = height;
		recording   = false;
	}
	
	public int getWidth() {
		return width;
	}
	
	public void setWidth(int w) {
		width = w;
	}
	
	public int getHeight() {
		return height;
	}
	
	public void setHeight(int h) {
		height = h;
	}
	
	public int getLastWidth() {
		return lastWidth;
	}
	
	public void setLastWidth(int lw) {
		lastWidth = lw;
	}
	
	public int getLastHeight() {
		return lastHeight;
	}
	
	public int getToolsOption() {
		return toolsOption;
	}
	
	public void setToolsOption(int op) {
		toolsOption = op;
	}
	
	public boolean getFullScreen() {
		return fullScreen;
	}
	
	public void setFullScreen(boolean fs) {
		fullScreen = fs;
	}
	
	public void setViewOption(int op) {
		viewOption = op;
	}
	
	public int getViewOption() {
		return viewOption;
	}
	
	public void setFileOption(int op) {
		fileOption = op;
	}
	
	public int getFileOption() {
		return fileOption;
	}
	
	public void setRecording(boolean rec) {
		recording = rec;
	}
	
	public boolean getRecording() {
		return recording;
	}

}
