

package image;

import gaze.GazeIdentifier;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.*;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import java.awt.Point;

import tool.WriterReaderData;

import main.EyeOptions;
import main.ReceiveCoordenate;


public class DisplayImage extends JPanel implements MouseMotionListener {

	//buffer com a imagem original
	private BufferedImage original;

	//buffer utilizado para a imagem usando algum tool
	private BufferedImage toolBuffer;

	//buffer utilizado a principio para o modo estatico e para dinamico sem decaimento
	private BufferedImage maskBuffer;

	//opcoes gerais
	private EyeOptions eyeOptions;

	// processador de imagens
	private ImageProcessor imageProcessor;

	// indentificador de fixacoes
	private GazeIdentifier gazeIdentifier;

	// centro deslocado para o circulo
	private int centerX;
	private int centerY;

	//ultimos centros
	private int lastCenterX;
	private int lastCenterY;

	// classe auxiliar para escrever os dados no arquivo
	// soh para o tool static
	private WriterReaderData writerReaderData;

	// alpha para desenho das fixacoes
	private AlphaComposite alphaComposite;

	//alpha para implementar o decaimento
	private AlphaComposite alphaDecline;

	private DeclineFixations declineFixations;

	// constantes
	private static final long serialVersionUID = 1L;

	private static final int RAIO_CIRCLE = 100;

	//	 o quanto  perdido da imagem devido a uma convoluo gaussiana
	private static final int GAUSSIAN_BORDER = 7;
	
	private ReceiveCoordenate receiveCoodenate;


	/**
	 * A vesao atual  uma versao usando o mouse como entrada
	 * Usado para testes
	 * Para usar uma versao com entrada usando o EyeTracking  necessario descomentar as ultimas 
	 * linhas do construtor
	 */

	public DisplayImage(String p, EyeOptions eo) {

		try {
			String path = p;

			File file = new File(path);

			Image image = ImageIO.read(file);

			original = createBufferedImage(image);

			toolBuffer = cloneBuffer(original);

			eyeOptions = eo;

			imageProcessor = new ImageProcessor(original);

			gazeIdentifier = new GazeIdentifier();

			writerReaderData = new WriterReaderData();

			lastCenterX = -1;
			lastCenterY = -1;

			maskBuffer = new BufferedImage(toolBuffer.getWidth(), toolBuffer.getHeight(),
					BufferedImage.TYPE_INT_ARGB);

			alphaComposite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER);

			alphaDecline   = AlphaComposite.getInstance(AlphaComposite.SRC_OVER);

			declineFixations = new DeclineFixations();

			addMouseMotionListener(this);
			
			/*
			 * Para Rodar usando o EyeTracking
			 * 
			 * receiveCoordenate = new ReceiveCoordenate(this);
			 * receiveCoodenate.start();
			 * 
			 */


		}
		catch (IOException e) {

			e.printStackTrace();

		}
	}

	// cria um clone do buffer im
	public BufferedImage cloneBuffer(BufferedImage im) {

		BufferedImage bi = new BufferedImage(im.getWidth(), im.getHeight(),
				BufferedImage.TYPE_INT_ARGB);
		Graphics2D g = bi.createGraphics();
		g.drawImage(im, null, 0, 0);

		return bi;

	}

	// metodo que desenha usando o metodo estatico
	//@Deprecated
	public void paintStaticTool(int lastx, int lasty, int x, int y, AlphaComposite ac) {
		Graphics g = toolBuffer.getGraphics();

		// obtenho o grafico do toolBuffer e seto o alpha composite

		((Graphics2D) g).setComposite(ac);
		((Graphics2D) g).setPaint(Color.red);

		//desenho a linha se nao for a 1a
		if (lastx != -1 && lasty != -1) 
			g.drawLine(lastx, lasty, x, y);

		//desenho o circulo
		((Graphics2D) g).fill(new Ellipse2D.Double(x - 5, y - 5, 10, 10));

	}
	
	//	 metodo que desenha usando o metodo estatico
	public void paintStaticToolMask(int lastx, int lasty, int x, int y, AlphaComposite ac) {

		Graphics g = maskBuffer.getGraphics();

		// obtenho o grafico do toolBuffer e seto o alpha composite

		((Graphics2D) g).setComposite(ac);
		((Graphics2D) g).setPaint(Color.red);

		//desenho a linha se nao for a 1a
		if (lastx != -1 && lasty != -1) 
			g.drawLine(lastx, lasty, x, y);

		//desenho o circulo
		((Graphics2D) g).fill(new Ellipse2D.Double(x - 5, y - 5, 10, 10));

	}


	// sobrescrevo o metodo paint
	public void paint(Graphics g) { 

		int tools = eyeOptions.getToolsOption();
		int view  = eyeOptions.getViewOption();

		switch(tools) {
		case 0:
			((Graphics2D)g).drawImage(toolBuffer, null, 0, 0);
			break;
		case 1:
			((Graphics2D)g).drawImage(toolBuffer, null, 0, 0);
			((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);
			break;
		case 2:
			((Graphics2D)g).drawImage(toolBuffer, null, 0, 0);
			((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);
			break;
		case 3:
			((Graphics2D)g).drawImage(toolBuffer, null, 0, 0);
			((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);
			break;
		default:
			break;
		}

		switch(view) {
		case 0:

			//visualizacao normal
			break;

		case 1:
			//Binario

			// desenho o fundo preto
			((Graphics2D) g).drawImage(imageProcessor.getBufferBlack(), null, 0, 0);

			// nao sei se isso vai ficar mto lento!!! em fase de testes ... se ficar ruim, substituir pela linha acima
			((Graphics2D) g).setPaint(imageProcessor.createTexture(toolBuffer));

			// preencho um circulo com a textura original 
			((Graphics2D) g).fill(imageProcessor.setPositionOfEllipse(centerX, centerY, RAIO_CIRCLE));

			//crio um texture
			((Graphics2D) g).setPaint(imageProcessor.createTexture(maskBuffer));
			// preencho um circulo com a textura original para a mascara dee fixacoes
			((Graphics2D) g).fill(imageProcessor.setPositionOfEllipse(centerX, centerY, RAIO_CIRCLE));

			//preenche a parte da tela que no contm imagem (moldura cinza)			
			g.setColor(Color.LIGHT_GRAY);
			// lado direito da moldura
			((Graphics2D) g).fillRect(original.getWidth(), 0, 1152 - original.getWidth(), original.getHeight());
			//lado esquerdo da moldura
			((Graphics2D) g).fillRect(0, original.getHeight(), 1152, 864 - original.getHeight());


			break;

		case 2:
			//Gaussiano

			// desenho o buffer convoluido com a maior mascara
			((Graphics2D) g).drawImage(imageProcessor.getBufferGaussian2(), null, 0, 0);

			// obtenho a textura do buffer convoluido com a menor mascara
			((Graphics2D) g).setPaint(imageProcessor.getTextureGaussian1());

			// preencho o circulo de buffer convoluido com a menor mascara
			((Graphics2D) g).fill(imageProcessor.setPositionOfEllipse(centerX - RAIO_CIRCLE, centerY - RAIO_CIRCLE, 3*RAIO_CIRCLE));

			// obtenho a textura do buffer com a imagem original
			((Graphics2D) g).setPaint(imageProcessor.getTextureOriginal());

			// preencho o circulo com o buffer original
			((Graphics2D) g).fill(imageProcessor.setPositionOfEllipse(centerX, centerY, RAIO_CIRCLE));


			//(moldura cinza) preenche a parte da tela que no contm imagem 
			g.setColor(Color.LIGHT_GRAY);
			// lado direito da moldura
			((Graphics2D) g).fillRect(original.getWidth()- GAUSSIAN_BORDER, 0, 1152 - original.getWidth() , original.getHeight());
			// parte inferior da moldura
			((Graphics2D) g).fillRect(0, original.getHeight()- GAUSSIAN_BORDER, 1152, 864 - original.getHeight());
			//lado esquerdo da moldura
			((Graphics2D) g).fillRect(0, 0, GAUSSIAN_BORDER, 864);
			//parte superior da moldura
			((Graphics2D) g).fillRect(0, 0, 1152, GAUSSIAN_BORDER);

			//preencho com a mascara ded fixacoes
			((Graphics2D)g).drawImage(maskBuffer, null, 0, 0);

			break;
		}
	}

	// Cria um bufferedImage a partir de um Image
	public BufferedImage createBufferedImage(Image image)
	{
		BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null),
				BufferedImage.TYPE_INT_ARGB);
		Graphics2D g = bi.createGraphics();
		g.drawImage(image, 0, 0, null);

		return bi;
	}

	// restarta o last para -1
	public void reSetLast() {

		if (lastCenterX == -1)
			return;
		else {
			lastCenterX = -1;
			lastCenterY = -1;
		}

	}

	//limpa o rastreamento anterior
	public void clearImage() {
		Graphics2D g = (Graphics2D) toolBuffer.getGraphics();
		g.drawImage(original, null, 0, 0);

		maskBuffer = new BufferedImage(toolBuffer.getWidth(), toolBuffer.getHeight(),
				BufferedImage.TYPE_INT_ARGB);

		declineFixations.removeAll();

		repaint();
	}

	// desenha o tool estatico na tela
	// faz a iteracao aqui mesmo, pois assim nao eh necessario criar
	// uma lista para depois iterar
	public void displayStatic() {
		int gr;
		double cx, cy;

		// le a 1a linha
		String line = writerReaderData.readNextLine();

		//crio a regra de composicao de alpha

		alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.1);

		//inic o ultimo elemento com -1
		int lastx = -1;
		int lasty = -1;

		// enquanto a existir linhas no arquivo
		while(line != null) {

			System.out.println(line);

			// indentifica a fixacao e verifica se esta no estado fixo
			gazeIdentifier.identifyGaze(line);
			gr = gazeIdentifier.checkFix();

			// se ocorreu fixacao o gazeIdentifier devolve um inteiro que 
			// representa o grupo fixo, cc devolve -1
			if (gr != -1) {
				//obtenho o centro do grupo fixo
				cx = gazeIdentifier.centerX[gr];
				cy = gazeIdentifier.centerY[gr];

				//desenho o ponto
				paintStaticToolMask(lastx, lasty, (int)cx, (int)cy, alphaComposite);

				lastx = (int)cx;
				lasty = (int)cy;
			}
			//intero para a proxima linha
			line = writerReaderData.readNextLine();

		}

		writerReaderData.closeReader();

		repaint();

	}

	//fecha o escritor
	public void closeWriter() {

		writerReaderData.closeWriter();

	}

	//desenha o dinamico com dedcaimento usando uma lista dinamica
	public void displayDynamicDeclineList(int centerX, int centerY, int lastX, int lastY) {

		declineFixations.addPoint(new Point(centerX, centerY));
		declineFixations.removePoint();

		//Big gambiarra, para o binario utilizo a mascara de fixacoes pois esta obteve uma visualizacao mais suave
		//(ou menos pior) !!! Para os outros utilizo a mascara de fixacoes
		Graphics g;

		maskBuffer = new BufferedImage(toolBuffer.getWidth(), toolBuffer.getHeight(),
				BufferedImage.TYPE_INT_ARGB);

		g = maskBuffer.getGraphics();


		//itero sobre a lista de fixacoes
		float i = ((float)0.5/(float)declineFixations.fixations.size());
		int lastx = -1;
		int lasty = -1;
		int j = 1;
		for (Point p : declineFixations.fixations) {

			alphaDecline = AlphaComposite.getInstance(alphaComposite.getRule(), (float) i*j);
			((Graphics2D) g).setComposite(alphaDecline);

			((Graphics2D) g).setPaint(Color.red);

			//desenho a linha se nao for a 1a
			if (lastx != -1 && lastx != -1) 
				g.drawLine(lastx, lasty, p.x, p.y);

			//		desenho o circulo
			((Graphics2D) g).fill(new Ellipse2D.Double(p.x - 5, p.y - 5, 10, 10));

			lastx = p.x;
			lasty = p.y;

			j++;
		}

	}

	//desenha o dinamico com decaimento
	//@deprecated
	public void displayDynamicDecline(int centerX, int centerY, int lastX, int lastY) {

		Graphics g = toolBuffer.getGraphics();

		if (alphaDecline.getAlpha() != 0.1)
			alphaDecline = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.1);
		((Graphics2D) g).setComposite(alphaDecline);
		((Graphics2D)g).drawImage(original, null, 0, 0);

		if (alphaComposite.getAlpha() != 0.5)
			alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.5);

		// obtenho o grafico do toolBuffer e seto o alpha composite 
		((Graphics2D) g).setComposite(alphaComposite);
		((Graphics2D) g).setPaint(Color.red);

		//desenho a linha se nao for a 1a
		if (lastX != -1 && lastY != -1) 
			g.drawLine(lastX, lastY, centerX, centerY);

		//		desenho o circulo
		((Graphics2D) g).fill(new Ellipse2D.Double(centerX - 5, centerY - 5, 10, 10));

		repaint();

	}

	//desenha o dinamico sem decaimento
	public void displayDynamic(int centerX, int centerY, int lastX, int lastY) {

		Graphics g = maskBuffer.getGraphics();

		if (alphaComposite.getAlpha() != 0.1)
			alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), (float) 0.1);

		// obtenho o grafico do toolBuffer e seto o alpha composite
		//Graphics g = toolBuffer.getGraphics(); 
		((Graphics2D) g).setComposite(alphaComposite);
		((Graphics2D) g).setPaint(Color.red);

		//desenho a linha se nao for a 1a
		if (lastX != -1 && lastY != -1) 
			g.drawLine(lastX, lastY, centerX, centerY);

		//		desenho o circulo
		((Graphics2D) g).fill(new Ellipse2D.Double(centerX - 5, centerY - 5, 10, 10));

		repaint();
	}

	// faz as respectivas operacoes para a coordenada x e y
	public void tool(int centerX, int centerY) {
		int tool = eyeOptions.getToolsOption();

		switch(tool) {

		case 0:
			break;
		case 1:

			if (eyeOptions.getRecording()) {
				writerReaderData.writeInFile(centerX, centerY);
			}

			break;
		case 2:

			if (eyeOptions.getRecording()) {

				displayDynamic(centerX, centerY, lastCenterX, lastCenterY);

				lastCenterX = centerX;
				lastCenterY = centerY;

			}
			else {

				reSetLast();

			}

			break;
		case 3:
			if (eyeOptions.getRecording()) {

				displayDynamicDeclineList(centerX, centerY, lastCenterX, lastCenterY);
				lastCenterX = centerX;
				lastCenterY = centerY;

			}
			else {

				reSetLast();

			}
			break;
		}
	}

	public void mouseMoved(MouseEvent e) {
		int gr;
		double cx, cy;

		centerX = e.getX() - RAIO_CIRCLE / 2;
		centerY = e.getY() - RAIO_CIRCLE / 2;

		//indentifica a fixacao e verifica se esta no estado fixo
		gazeIdentifier.identifyGaze(e.getX() + " " + e.getY());
		gr = gazeIdentifier.checkFix();

		// se ocorreu fixacao o gazeIdentifier devolve um inteiro que 
		// representa o grupo fixo, cc devolve -1
		if (gr != -1) {
			
			//obtenho o centro do grupo fixo
			cx = gazeIdentifier.centerX[gr];
			cy = gazeIdentifier.centerY[gr];

			tool((int)cx, (int)cy);

			repaint();
		}
	}
	
	public void novaCoordenada(int x, int y) {
		int gr;
		double cx, cy;

		centerX = x - RAIO_CIRCLE / 2;
		centerY = y - RAIO_CIRCLE / 2;

		//indentifica a fixacao e verifica se esta no estado fixo
		gazeIdentifier.identifyGaze(x + " " + y);
		gr = gazeIdentifier.checkFix();

		// se ocorreu fixacao o gazeIdentifier devolve um inteiro que 
		// representa o grupo fixo, cc devolve -1
		if (gr != -1) {
			
			//obtenho o centro do grupo fixo
			cx = gazeIdentifier.centerX[gr];
			cy = gazeIdentifier.centerY[gr];

			tool((int)cx, (int)cy);

			repaint();
		}
	}


	public void mouseDragged(MouseEvent e) {
		// TODO Auto-generated method stub

	}

}