package gaze;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import java.awt.image.BufferedImage;

import javax.swing.JPanel;

public class GazeIdentifierImageTest extends JPanel implements  MouseListener{

	private static final long serialVersionUID = 1L;
	
	private BufferedImage bi;
	
	private GazeIdentifier gaze;
	
	public GazeIdentifierImageTest() {
		
		gaze = new GazeIdentifier();
		
		addMouseListener(this);
		
		initPaint();
		
	}
	
	public void initPaint() {
		bi = new BufferedImage(800, 600,
				BufferedImage.TYPE_INT_ARGB);
		Graphics g = bi.createGraphics();
		g.setColor(Color.black);
		g.fillRect(0, 0, 800, 600);
	}
	
	public void paint(Graphics g) {
		((Graphics2D)g).drawImage(bi, null, 0, 0);
	
	}
	
	public void paintVisualization(int x, int y, double[] centerX, double[] centerY) {
		
		Graphics g = bi.getGraphics();
		
		g.setColor(Color.white);
		g.drawOval(x - 36, y - 36, 72, 72);
		
		g.setColor(Color.red);
		g.drawLine(x, y, x, y);
		
		g.setColor(Color.yellow);
		for(int i = 0; i < centerX.length; i++) {
			g.drawLine((int)centerX[i], (int)centerY[i], (int)centerX[i], (int)centerY[i]);
			g.drawOval((int)centerX[i] - 36, (int)centerY[i] - 36, 72, 72);
		}
		
		repaint();
	}

	public void mouseClicked(MouseEvent arg0) {

		System.out.println("x = " + arg0.getX());
		System.out.println("y = " + arg0.getY());
		
		gaze.identifyGaze(arg0.getX() + " " + arg0.getY());
		
		gaze.printWindow();
		gaze.printNGroup();
		gaze.printSetGaze();
		gaze.printGroupCenterX();
		
		paintVisualization(arg0.getX(), arg0.getY(), gaze.getCenterX(), gaze.getCenterY());
		
	}

	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	
}
