package gaze;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;



public class GazeIdentifier {

	// //////////////////////////////////////////////
	// Esta classe tem metodos para identificacao de
	// fixacoes. Para o modo estatico foi decido
	// fazer a iteracao fora da classe GazeIdentifier
	// pois assim nao h o risco de se criar uma lista
	// de pontos mto grande usando memoria adicional



	// string com o arquivo de dados para o metodo estatico
	protected static final String STATIC_FILE = "C:\\Documents and Settings\\Adalberto\\workspace\\";

	// inteiro q define o numero de amostras em um grupo para ser considerado
	// uma fixacao
	protected static final int FIXED = 3;
	
	// ///////////////////////////////////////////
	// Atributos usados para para o modo estatico
	// ///////////////////////////////////////////

	// grupos
	private Set<Integer> setGaze;

	// janela de amostras
	private LinkedList<WindowComponent> window;

	// vetor que indica o numero de elementos em cada grupo
	private int nGroup[];

	// vetores com os valores dos centros dos respectivos grupos
	public double centerX[];
	public double centerY[];


	// construtor
	public GazeIdentifier() {

		initializeAll();

	}

	// inicializa o setGaze
	public void initializeAll() {

		if (setGaze == null) {

			setGaze = new TreeSet<Integer>();
			setGaze.add(new Integer(0));
			setGaze.add(new Integer(1));
			setGaze.add(new Integer(2));
			setGaze.add(new Integer(3));
			setGaze.add(new Integer(4));
		}

		window = new LinkedList<WindowComponent>();

		nGroup = new int[5];
		for (int i = 0; i < nGroup.length; i++)
			nGroup[i] = 0;

		centerX = new double[5];
		centerY = new double[5];
		for (int i = 0; i < centerX.length; i++) {
			centerX[i] = -100;
			centerY[i] = -100;
		}
	}
	
	// metodo q verfica se ocorreu uma fixacao nao iteracao
	// se ocorreu retorna um inteiro que representa o grupo
	// que ocorreu a fixacao, se for sacada retorna -1
	public int checkFix() {
		int check = -1;
	
		for (int i = 0; i < nGroup.length; i++) {
			if (nGroup[i] >= 3) {
				check = i;
				return check;
			}
		}
		
		return check;
	}

	// metodo que identifica se ocorreu fixacao
	// o parametro coordenates  uma string com
	// 2 inteiros no qual o primeiro inteiro representa a
	// coordenada x e o segundo representa a coordenada y
	public void identifyGaze(String coordenates) {
		String[] line; 

		line = coordenates.split(" ");

		int x = Integer.parseInt(line[0]);
		int y = Integer.parseInt(line[1]);

		WindowComponent comp = new WindowComponent(x, y);

		// para facilitar vou considerar a analise
		// s quando tivermos um historio de 5 amostras
		if (window.size() < 5) {
			iterateWindow(comp);
			return;
		}

		// se cair nesse caso nossa janela ja possui
		// um historico de 5 amostras e assim podemos
		// analizar se ocorreu uma fixacao ou nao
		else {
			removeWindowElement();
			iterateWindow(comp);

		}

	}

	// mtodo que calcula a area em que pontos sao considerados "o mesmo"
	// raio de aproximadamente uma polegada
	// verifica se o ponto da tableXY[i + 1] est na area do circulo de
	// centro tableXY[i] e raio 2,5 cm
	private boolean inCircleArea(WindowComponent c1, WindowComponent c2) {
		
		double x = c1.centerX - c2.pixelX;
		double y = c1.centerY - c2.pixelY ;
		x = x * x;
		y = y * y;

		return (x + y <= 36*36);

	}
	
	// verifica se o componente c2 pertence ao centro x e ao centro y
	private boolean inCircleArea(double centerX, double centerY, WindowComponent c2) {
		
		double x = centerX - c2.pixelX;
		double y = centerY - c2.pixelY;
		x = x * x;
		y = y * y;

		return (x + y <= 36*36);

	}


	// remove o primeiro elemento da fila fifo e recalcula os centros do grupo
	// do elemento q saiu
	private void removeWindowElement() {
		
		WindowComponent out = ((WindowComponent)(window.removeFirst()));

		Integer groupOut = out.getGroup();
		
		nGroup[groupOut.intValue()]--;
		
		if (nGroup[groupOut.intValue()] == 0) {
			centerX[groupOut.intValue()] = -100;
			centerY[groupOut.intValue()] = -100;
			setGaze.add(groupOut);
		}
		
		else {
			recalculateCenterAfterRemove(out);
		}
	}
	
	// recalcula os centros do grupo group
	public void recalculateCenterAfterRemove(WindowComponent out) {
		
		Integer group;
		double sumX ;
		double sumY ;
		int n    ;
		
		group = out.getGroup();
		n = nGroup[group.intValue()];
		
		sumX = centerX[group.intValue()] * (n + 1);
		sumY = centerY[group.intValue()] * (n + 1);
		sumX = sumX - out.pixelX;
		sumY = sumY - out.pixelY;
		
		centerX[group.intValue()] = (double)sumX/n;
		centerY[group.intValue()] = (double)sumY/n;
		

	}
	
	// inicializa a janela
	public void iterateWindow(WindowComponent wc) {
		if (window.size() == 0) {
			wc.setCenters(wc.pixelX, wc.pixelY);

			Integer group = removeGroupElement();

			wc.setGroup(group);

			nGroup[group.intValue()]++;

			centerX[group.intValue()] = wc.centerX;
			centerY[group.intValue()] = wc.centerY;
		}

		else {

			TreeSet inWCA = inWindowCircleArea(wc);
			if (inWCA != null)
				recalculateCenter(inWCA, wc);

		}

		window.add(wc);
	}

	public void aloneOrGroup(double centX, double centY, WindowComponent comp, Integer obj) {

		if(inCircleArea(centX, centY, comp)) {
			comp.centerX = centX;
			comp.centerY = centY;

			comp.setGroup(obj);
			nGroup[obj.intValue()]++;
			
			centerX[obj.intValue()] = comp.centerX;
			centerY[obj.intValue()] = comp.centerY;
		}

		else {
			comp.centerX = comp.pixelX;
			comp.centerY = comp.pixelY;
			Integer alone = removeGroupElement();
			comp.setGroup(alone);
			nGroup[alone.intValue()]++;
			
			centerX[alone.intValue()] = comp.centerX;
			centerY[alone.intValue()] = comp.centerY;

		}
	}

	// recalcula os centros
	// metodo complicadissimo de entender
	// quero ver alguem entender isto
	public void recalculateCenter(TreeSet inWCA, WindowComponent wc) {

		double sumX = 0;
		double sumY = 0;
		int n    = 0;

		Iterator i = inWCA.iterator();
		while (i.hasNext()) {   

			Integer obj = (Integer) i.next();

			sumX = sumX + (nGroup[obj.intValue()]*centerX[obj.intValue()]);
			sumY = sumY + (nGroup[obj.intValue()]*centerY[obj.intValue()]);
			
			n = n + nGroup[obj.intValue()];

			setGaze.add(obj);
			nGroup[obj.intValue()] = 0;

		}

		sumX = sumX + wc.pixelX;
		sumY = sumY + wc.pixelY;

		n++;
		
		Integer obj = removeGroupElement();

		for(int j = 0; j < window.size(); j++) {

			WindowComponent comp = (WindowComponent) window.get(j);

			i = inWCA.iterator();
			while (i.hasNext()) {

				if (comp.getGroup() == i.next())
					aloneOrGroup(sumX/n, sumY/n, comp, obj);
			}
		}
		aloneOrGroup(sumX/n, sumY/n, wc, obj);


	}

	// verifica se o novo componente pertence a algum grupo
	// retorna uma lista ligada com os grupos no qual o novo componente
	// pertenceria (pode ser varios a principio)
	public TreeSet inWindowCircleArea(WindowComponent newWc) {

		TreeSet<Integer> inWCA = null;

		for(int j = 0; j < window.size(); j++) {
			WindowComponent wc = (WindowComponent) window.get(j);

			if (inCircleArea(wc, newWc)) {
			
				if (inWCA == null) {
					inWCA = new TreeSet<Integer>();
				}

				inWCA.add(wc.group);

			}
		}

		if (inWCA == null) {
			newWc.centerX = newWc.pixelX;
			newWc.centerY = newWc.pixelY;
			Integer alone = removeGroupElement();
			newWc.setGroup(alone);
			nGroup[alone.intValue()]++;
			
			centerX[alone.intValue()] = newWc.centerX;
			centerY[alone.intValue()] = newWc.centerY;
		}


		return inWCA;
	}


	// remove um elemento do grupo
	public Integer removeGroupElement() {
		Integer group = (Integer) ((TreeSet<Integer>) setGaze).first();
		setGaze.remove(group);

		return group;
	}
	
	// retorna o grupo em q esta fixo, caso seja uma sacada retorna -1
	public int isFixed() {
		
		for (int i = 0; i < nGroup.length; i++) {
			if (nGroup[i] >= FIXED)
				return i;
		}
		
		return (-1);
	}

	// metodos para testes

	public void printWindow() {

		Iterator it = window.iterator();
		System.out.print("pixelX");
		while (it.hasNext()) {
			System.out.print("-> " + ((WindowComponent)it.next()).pixelX);
		}
		System.out.println();

		it = window.iterator();
		System.out.print("pixelY");
		while (it.hasNext()) {
			System.out.print("-> " + ((WindowComponent)it.next()).pixelY);
		}
		System.out.println();

		it = window.iterator();
		System.out.print("centerX");
		while (it.hasNext()) {
			System.out.print("-> " + ((WindowComponent)it.next()).centerX);
		}
		System.out.println();

		it = window.iterator();
		System.out.print("centerY");
		while (it.hasNext()) {
			System.out.print("-> " + ((WindowComponent)it.next()).centerY);
		}
		System.out.println();


	}

	public void printNGroup() {
		System.out.print("nGrupo: ");
		for (int i = 0; i <= 4 ; i++) {
			System.out.print(" " + nGroup[i] + " ");
		}
		System.out.println();
	}

	public void printSetGaze() {
		System.out.print("Grupos fora de uso-> ");
		Iterator it = setGaze.iterator();
		while(it.hasNext()) {
			System.out.print(((Integer)it.next()).intValue());
		}
		System.out.println();
	}
	
	public void printGroupCenterX() {
		System.out.print("centros dos grupos: ");
		for (int i = 0; i < centerX.length; i++) {
			System.out.print(i + "->" + centerX[i] + " ");
		}
	}

	public double[] getCenterX() {
		return centerX;
	}

	public double[] getCenterY() {
		return centerY;
	}



// celula da janela de tamanho 5.
	public class WindowComponent {

		public int pixelX;

		public int pixelY;

		public double centerX;

		public double centerY;

		private Integer group;
		
		public WindowComponent(int x, int y) {
			pixelX = x;
			pixelY = y;
		}

		public void setCenters(int x, int y) {
			centerX = x;
			centerY = y;
		}

		public void setGroup(Integer g) {
			group = g;
		}

		public Integer getGroup() {
			return group;
		}



	}
}


/*
 * 
 * import java.awt.TexturePaint; import java.io.BufferedReader; import
 * java.io.File; import java.io.FileNotFoundException; import
 * java.io.FileReader; import java.io.IOException; import java.util.LinkedList;
 * import java.util.Stack;
 * 
 * 
 * //falta atualizar o centro public class Tracking { // variables private File
 * file;
 * 
 * private LinkedList janela;
 * 
 * private Stack grupoForaDeUso;
 * 
 * private String state = "S";
 * 
 * private int[] contGrupo = {0, 0, 0, 0, 0};
 * 
 * private LinkedList fixstates = new LinkedList();
 * 
 * private SimplePlayer player;
 * 
 * private static boolean first = true;
 * 
 * public Tracking(File file, SimplePlayer p) { this.file = file; player = p; //
 * initializeTable(); janela = new LinkedList(); grupoForaDeUso = new Stack();
 * 
 * grupoForaDeUso.push(new Integer(4)); grupoForaDeUso.push(new Integer(3));
 * grupoForaDeUso.push(new Integer(2)); grupoForaDeUso.push(new Integer(1));
 * grupoForaDeUso.push(new Integer(0));
 * 
 *  }
 * 
 * public void initializeTable() { String linha;
 * 
 * BufferedReader in; try { in = new BufferedReader(new FileReader(file)); linha =
 * in.readLine(); while (linha != null) { identifyGaze(linha); linha =
 * in.readLine(); } } catch (FileNotFoundException e1) { // TODO Auto-generated
 * catch block e1.printStackTrace(); } catch (IOException e) { // TODO
 * Auto-generated catch block e.printStackTrace(); } }
 * 
 * 
 * public void identifyGaze(String linha) { int x , y, i = 0; String[] line;
 * line = linha.split(" ");
 * 
 * x = Integer.parseInt(line[0]); y = Integer.parseInt(line[1]);
 * 
 * ComponenteDaJanela c = new ComponenteDaJanela(x, y);
 * 
 * if (janela.size() < 5) { janela.addLast(c); iteraJanela(c, -2, 0, 0); return; }
 * else { janela.addLast(c); int g =
 * ((ComponenteDaJanela)janela.removeFirst()).getGrupoPertencente(); int
 * novoCenterX ,novoCenterY, nG; novoCenterX = novoCenterY = nG = 0; for(int j =
 * 0; j < janela.size() - 1; j++) { ComponenteDaJanela comp =
 * (ComponenteDaJanela) janela.get(j); if(g == comp.getGrupoPertencente() && j <
 * 5) { nG++; novoCenterX += comp.getCentroX(); novoCenterY +=
 * comp.getCentroY(); }
 *  } if (nG != 0) { novoCenterX /= nG; novoCenterY /= nG; } iteraJanela(c, g,
 * novoCenterX, novoCenterY); }
 * 
 *  }
 * 
 * 
 * public void iteraJanela(ComponenteDaJanela c, int g, int novoCenterX, int
 * novoCenterY) { int nG = 0; if (janela.size() == 1) {
 * c.setCentroX(c.getPixelX()); c.setCentroY(c.getPixelY()); int gr =
 * ((Integer)grupoForaDeUso.pop()).intValue(); c.setGrupos(gr);
 * c.setGrupoPertencente(gr);
 * 
 *  } else { for (int i = 0; i < janela.size() - 1; i++) { ComponenteDaJanela
 * comp = (ComponenteDaJanela) janela.get(i); if(g == comp.getGrupoPertencente() &&
 * i < 5) { nG++; comp.setCentroX(novoCenterX); comp.setCentroY(novoCenterY); }
 * if (inCircleArea(comp, c) && (!c.containGrupo(comp.getGrupoPertencente()))) {
 * c.setGrupos(comp.getGrupoPertencente()); } } if(nG == 0 && g != -2)
 * {grupoForaDeUso.push(new Integer(g)); System.out.println("Deu um push aki");}
 * calculaNovoGrupo(); } //imprime janela para verificar se esta tudo certo
 * 
 * //System.out.println("-------------------------------------------------------------");
 * //for(int i = 0; i < janela.size(); i++) { //c = (ComponenteDaJanela)
 * janela.get(i); //System.out.println("Grupo: " + c.getGrupoPertencente() );
 * //System.out.println("PixelX: " + c.getPixelX());
 * //System.out.println("PixelY: " + c.getPixelY());
 * //System.out.println("centroX: " + c.getCentroX());
 * //System.out.println("centroY: " + c.getCentroY());
 * //System.out.println("State: " + state); //System.out.println(); //}
 *  }
 *  // mtodo que calcula a area em que pontos sao considerados "o mesmo" //
 * raio de aproximadamente uma polegada // verifica se o ponto da tableXY[i + 1]
 * est na area do circulo de // centro tableXY[i] e raio 2,5 cm private boolean
 * inCircleArea(ComponenteDaJanela c1, ComponenteDaJanela c2) { int x =
 * c2.getPixelX() - c1.getCentroX(); int y = c2.getPixelY() - c1.getCentroY(); x =
 * x * x; y = y * y;
 * 
 * return (x + y <= 36*36);
 *  }
 * 
 * //Metodo que calcula o novo grupo
 * 
 * public void calculaNovoGrupo() { ComponenteDaJanela c = (ComponenteDaJanela)
 * janela.getLast(); int n = c.getGrupos().size(); int nG = 0; state = "S";
 * 
 * for(int i = 0; i < janela.size(); i++) { contGrupo[i] = 0; }
 * 
 * if (n == 0) { System.out.println("entrouaki"); c.setCentroX(c.getPixelX());
 * c.setCentroY(c.getPixelY()); int i =
 * ((Integer)grupoForaDeUso.pop()).intValue(); System.out.println(i);
 * c.setGrupos(i); c.setGrupoPertencente(i); } else {
 * System.out.println("entrouaki2"); int j = -1; boolean first = false; int
 * newCenterX, newCenterY; newCenterX = 0; newCenterY = 0; for (int i = 0; i <
 * janela.size(); i++) { ComponenteDaJanela comp = (ComponenteDaJanela)
 * janela.get(i); if (c.containGrupo(comp.getGrupoPertencente()) ||
 * comp.getGrupoPertencente() == -1) { newCenterX += comp.getPixelX();
 * newCenterY += comp.getPixelY(); nG++; if(!first) { j =
 * comp.getGrupoPertencente(); first = true; } } }
 * 
 * newCenterX /= nG; newCenterY /= nG;
 * 
 * System.out.println(newCenterX + " " + newCenterY);
 * 
 * int grupo = -1; for (int i = 0; i < janela.size(); i++) { ComponenteDaJanela
 * comp = (ComponenteDaJanela) janela.get(i); if
 * (c.containGrupo(comp.getGrupoPertencente()) || comp.getGrupoPertencente() ==
 * -1) { comp.setCentroX(newCenterX); comp.setCentroY(newCenterY); grupo =
 * comp.getGrupoPertencente(); if (grupo != j && grupo != -1) if
 * (!grupoForaDeUso.contains(new Integer(grupo))) grupoForaDeUso.push(new
 * Integer(grupo)); comp.setGrupoPertencente(j); } } }
 * 
 * int x, y; x = y = 0; for(int i = 0; i < janela.size(); i++) {
 * ComponenteDaJanela comp = (ComponenteDaJanela) janela.get(i); int grupo =
 * comp.getGrupoPertencente(); System.out.println("grupo: " + grupo);
 * contGrupo[grupo]++; if(contGrupo[grupo] >= 3) { state = "F"; x =
 * comp.getCentroX(); y = comp.getCentroY(); } } if(state == "F") {
 * 
 * StateFix newElement = new StateFix(x, y); //if(x != -1 || y != -1) { if
 * (player.getDj().filterType == 3) { fixstates.add(newElement); } else if
 * (player.getDj().filterType == 4) { fixstates.add(newElement);
 * player.getDj().showDinamicCleaner(fixstates); } else if
 * (player.getDj().filterType == 5) { player.getDj().showDinamic(newElement); }
 * 
 *  }
 * 
 * //} }
 * 
 * public void showStatic() { player.getDj().initializeStatic();
 * player.getDj().ShowStatic(fixstates);
 *  }
 * 
 * 
 *  // celula da janela de tamanho 5. public class ComponenteDaJanela { private
 * int pixelX = 0;
 * 
 * private int pixelY = 0;
 * 
 * private int centroX = 0;
 * 
 * private int centroY = 0;
 * 
 * private int grupoPertencente = -1;
 * 
 * private LinkedList grupos = new LinkedList();
 * 
 * 
 * ComponenteDaJanela(int x, int y) { pixelX = x; pixelY = y; }
 * 
 * 
 * 
 * public int getPixelX() { return pixelX; }
 * 
 * public int getPixelY() { return pixelY; }
 * 
 * public int getCentroX() { return centroX; }
 * 
 * public void setCentroX(int centroX) { this.centroX = centroX; }
 * 
 * public int getCentroY() { return centroY; }
 * 
 * public void setCentroY(int centroY) { this.centroY = centroY; }
 * 
 * public void setGrupos(int grupo) { grupos.addLast(new Integer(grupo)); }
 * 
 * public boolean containGrupo(int grupo) { for (int i = 0; i < grupos.size();
 * i++) { if (grupo == ((Integer) grupos.get(i)).intValue()) { return true; } }
 * return false; }
 * 
 * public LinkedList getGrupos() { return grupos; }
 * 
 * public void setGrupoPertencente(int grupo) { this.grupoPertencente = grupo; }
 * 
 * public int getGrupoPertencente() { return this.grupoPertencente; } } }
 * 
 * class StateFix {
 * 
 * private int centroX;
 * 
 * private int centroY;
 * 
 * private TexturePaint texture;
 * 
 * public StateFix(int x, int y) { centroX = x; centroY = y; }
 * 
 * public void setTexturePaint(TexturePaint tex){ texture = tex; }
 * 
 * public int getCentroX() { return centroX; }
 * 
 * public int getCentroY() { return centroY; } }
 */